(ns geospatial.codecs
  (:require [geospatial.codecs.core :as codec]
            [geospatial.codecs.formats :as fmt]
            [geospatial.codecs.formats.cartesianlonglat]
            [geospatial.codecs.formats.geojson]))

(defonce GeoJSONCodec (fmt/->GeoJSON))
(defonce CartesianLongLatCodec (fmt/->CartesianLongLat))

;;; Public API

(defn decode
  "Decode format to canonical model."
  {:added "0.1.0"}
  [codec data]
  (codec/-decode codec data))

(defn encode
  "Encode canonical model to output format"
  {:added "0.1.0"}
  [codec model]
  (codec/-encode codec model))

(defn convert
  "Encode initial data from one codec to another one"
  {:added "0.1.0"}
  [from-codec to-codec data]
  (->> data
       (decode from-codec)
       (encode to-codec)))
