(defproject io.trosa/geospatial "0.1.1-SNAPSHOT"
  :description "A pure-clojure library to deal with Geospatial format parsing,
                validation & Transformations, with compliance with associated RFCs."
  :url "https://github.com/iomonad/geospatial"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.12.4"]
                 [io.trosa/toolbox "1.1.4"]
                 [metosin/malli "0.19.1"]
                 [com.cnuernber/charred "1.037"]
                 [clj-http "3.13.1"]]
  :deploy-repositories [["snapshots" {:url "https://repo.clojars.org"
                                      :username :env/clojars_username
                                      :password :env/clojars_password
                                      :sign-releases false}]
                        ["releases"  {:url "https://repo.clojars.org"
                                      :username :env/clojars_username
                                      :password :env/clojars_password
                                      :sign-releases false}]]
  :plugins [[lein-cloverage "1.2.2"]]
  :profiles {:dev {:dependencies [[org.clojure/tools.namespace "1.5.0"]
                                  [spootnik/unilog "0.7.32"]]
                   :source-paths ["dev" "docs"]
                   :resource-paths ["dev-resources"]
                   :repl-options {:init-ns user
                                  :prompt #(str "\u001B[35m[\u001B[34m" % "\u001B[35m]\u001B[33m▶\u001B[m ")}}
             :clerk {:dependencies [[io.github.nextjournal/clerk "0.18.1158"]]
                     :source-paths ["docs"]
                     :aliases {"build-static" ["run" "-m" "build"]}}})
