(ns geospatial.geojson
  (:require [geospatial.geojson.specs :as spec
             :refer [valid-geojson? geojson-schema]]
            [malli.core  :as m]
            [malli.error :as me]))

(defn validate-geojson
  "Validate & Yield the GeoJSON datastructure.

   Throw with explaination when invalid."
  {:added "0.1.0"}
  [geojson]
  (if (and (map? geojson) (valid-geojson? geojson))
    geojson
    (throw (ex-info "GeoJSON Validation Error"
                    (me/humanize (m/explain geojson-schema geojson))))))

(defn get-coords
  "Yields all coordinate tuples from a geometry
   or feature object."
  {:added "0.1.0"}
  [geojson]
  (->> (spec/assert-geojson! geojson)
       (:coordinates)))

(defn transpose-coords
  "Maps a function over all coordinate values and returns a geometry
   of the same type.

   Can be useful for scaling a geometry."
  {:added "0.1.0"}
  [geojson transpose-fn]
  (-> (spec/assert-geojson! geojson)
      (update :coordinates
              (fn [coords]
                (mapv (fn [coord]
                        (mapv (fn [x]
                                (transpose-fn x)) coord))
                      coords)))))
