(ns geospatial.geocoding
  "Geocoding utils based on externals API's"
  (:require [clj-http.client :as http]
            [charred.api :as json]
            [geospatial.geojson.specs :refer [assert-geojson!]]))

(defprotocol GeocodingService
  (search [this] "High-level search method")
  (reverse-search [this] "High-level reverse-search method"))

(defonce geoplateforme-endpoint "https://data.geopf.fr/geocodage")
(defrecord GeoplateformeGouvFr [query]
  GeocodingService
  (search [{:keys [query]}]
    (when query
      (let [batched? (sequential? query)]
        (-> (http/get (format "%s/search" geoplateforme-endpoint)
                      {:query-params {:q query}})
            :body
            (json/read-json :key-fn keyword)
            (dissoc :query)
            (assert-geojson!))))))

(def default-geocode-params {:service :geoplateforme :codec :geojson})
(defn geocode
  "Retrieve geocoding of query."
  {:added "0.1.0"}
  ([query]
   (geocode query default-geocode-params))
  ([query {:keys [service codec]}]
   (when-let [builder (condp = service
                        :geoplateforme ->GeoplateformeGouvFr
                        (throw "No Geocoding implementation found"))]
     (->> (builder query)
          search))))
