(ns geospatial.codecs.formats.geojson
  (:require [geospatial.codecs.core :as codec]
            [geospatial.codecs.models :as models]
            [geospatial.codecs.formats]
            [geospatial.geojson :as geojson]
            [malli.core :as m])
  (:import geospatial.codecs.formats.GeoJSON))

(defn- decode-to-canonical*
  [data]
  (let [entities
        (->> (if (sequential? data) data [data])
             (mapv (fn [{:keys [coordinates] :as data}]
                     {:entity/geometry
                      {:geometry/type :point
                       :geometry/coordinates coordinates}})))]
    {:doc/entities entities}))

(defn- encode-to-canonical*
  [{:keys [type] :as data}]
  (let [entities []]
    {:type "Point"
     :coordinates (get-in data [:doc/entities 0 :entity/geometry :geometry/coordinates])}))

(extend-type GeoJSON
  codec/GeoCodec

  (-decode [_ data]
    (let [geojson (geojson/validate-geojson data)]
      (decode-to-canonical* data)))

  (-encode [_ data]
    (m/assert models/Document data)
    (encode-to-canonical* data)))
