(ns geospatial.codecs.formats.cartesianlonglat
  (:require [geospatial.codecs.core :as codec]
            [geospatial.codecs.models :as models]
            [geospatial.codecs.formats]
            [malli.core :as m])
  (:import geospatial.codecs.formats.CartesianLongLat))

(extend-type CartesianLongLat
  codec/GeoCodec

  (-decode [_ [lng lat]]
    {:doc/entities
     [{:entity/geometry
       {:geometry/type :point
        :geometry/coordinates [lng lat]}}]})

  (-encode [_ data]
    (m/assert models/Document data)
    (get-in data [:doc/entities 0 :entity/geometry
                  :geometry/coordinates])))
