(ns lib.webserver.utils
  (:require [reitit.core :as reitit]
            [clojure.string :as str]
            [clojure.tools.logging :as log]))

(defn route->name
  [{route-name :name}]
  {:added "1.1.0"}
  (cond
    (string? route-name) route-name
    (simple-keyword? route-name) (name route-name)
    (qualified-keyword? route-name) (str (namespace route-name) "." (name route-name))
    :else :unknown))

(defn pprint-ring-routes
  "Print the routes extracted to router into
   the logger.
   Should be used for debugging purposes only."
  {:added "1.1.0"}
  [ring-router]
  (let [routes (reitit/routes ring-router)]
    (->> routes
         (mapcat (fn [[r metadata]]
                   (let [methods (keys (select-keys metadata #{:get :post :put :patch :head}))]
                     (for [m methods]
                       (format "%-3s - %s" (str/upper-case (name m)) r)))))
         (run! (fn [r]
                 (log/infof "registred route - %s" r))))))
