(ns lib.webserver.interceptors
  (:require [lib.webserver.utils :refer [route->name]]
            [io.pedestal.interceptor.chain :as chain]))

(defn compiled-sentry-interceptor
  "Create interceptor to send exception to Sentry.
   Will be binded to the stack only "
  [{:keys [dsn send-ex-fn!] :as _sentry}]
  {:added "1.1.0"}
  (when dsn
    {:name ::sentry
     :compile (fn compile-sentry [{:keys [no-sentry] :as data} _]
                (let [route-name (route->name data)]
                  (when-not no-sentry
                    {:error (fn [ctx ^Throwable ex]
                              (let [error-msg {:message (str "Error on route " route-name) :level :error}]
                                (when send-ex-fn!
                                  (send-ex-fn! ex ctx error-msg)))
                              (assoc ctx ::chain/error ex))})))}))
