(ns lib.telemetry.interceptors
  (:require [lib.telemetry.instrumentation :as ti]))

(defn- server-request-attributes-interceptor
  "Extract and format request attributes used
   by deeper Opentelemetry span"
  [{:keys [selected-request-header]}]
  {:name :io.opentelemetry/request-attributes
   :enter (fn [{:keys [request] :as ctx}]
            (let [attributes (ti/pedestal-server-request-attrs request selected-request-header)]
              (update ctx :request assoc :io.opentelemetry/pedestal-request-attributes attributes)))})

(defn telemetry-interceptors
  "Create a stack of interceptors ready to be used by
   any pedestal webserver"
  [{:keys [with-span? with-context?] :as opts}]
  (cond-> []
    with-span?         (conj (server-request-attributes-interceptor opts))
                                        ;with-span?         (conj (new-server-span-interceptor with-span-opts))
                                        ; with-span?         (conj (response-data-interceptor))
                                        ;(not with-span?)   (conj (existing-server-span-interceptor))
                                        ; :always            (conj (execution-id-interceptor))
                                        ;:always            (conj (copy-context-interceptor))
                                        ;(and with-span? set-current-context?) (conj (current-context-interceptor))
                                        ;:always            (conj (bound-context-interceptor))
    ))
