;; ___________    .__                         __
;; \__    ___/___ |  |   ____   _____   _____/  |________ ___.__.
;;   |    |_/ __ \|  | _/ __ \ /     \_/ __ \   __\_  __ <   |  |
;;   |    |\  ___/|  |_\  ___/|  Y Y  \  ___/|  |  |  | \/\___  |
;;   |____| \___  >____/\___  >__|_|  /\___  >__|  |__|   / ____|
;;              \/          \/      \/     \/             \/

(try (load-file "common.clj")
     (catch java.io.FileNotFoundException _
       (load-file "../../common.clj")))

(def logback-version "1.4.13")
(def otlp-version "1.38.0")

(defproject io.trosa/component.telemetry components-version
  :plugins [[lein-monolith "1.9.0"]]
  :monolith/inherit true
  :deployable true
  :dependencies [[integrant]
                 [commons]]
  :profiles {:dev {:dependencies [[integrant/repl]
                                  [org.clojure/tools.namespace]
                                  [ch.qos.logback/logback-classic                           ~logback-version]
                                  [ch.qos.logback/logback-core                              ~logback-version]
                                  [io.opentelemetry/opentelemetry-api                       ~otlp-version]
                                  [io.opentelemetry/opentelemetry-sdk                       ~otlp-version]
                                  [io.opentelemetry/opentelemetry-sdk-common                ~otlp-version]
                                  [io.opentelemetry/opentelemetry-exporter-otlp             ~otlp-version]
                                  [io.opentelemetry/opentelemetry-exporter-logging          ~otlp-version]
                                  [io.opentelemetry.semconv/opentelemetry-semconv           "1.25.0-alpha"]
                                  [io.opentelemetry.semconv/opentelemetry-semconv-incubating "1.25.0-alpha"]
                                  [io.grpc/grpc-stub                                        "1.64.0"]]
                   :source-paths ["dev"]}
             :uberjar {:aot :all}})
