(ns component.sentry
  (:require [integrant.core :as ig]
            [clojure.tools.logging :as log]
            [malli.core :as m]
            [qbits.knit :as knit]
            [lib.sentry.core :as lib]
            [io.trosa.commons.models :refer [HttpUrl]])
  (:import [java.util.concurrent ExecutorService])
  (:gen-class))

;;    _____                               __
;;   /  _  \   ______ ______ ____________/  |_
;;  /  /_\  \ /  ___//  ___// __ \_  __ \   __\
;; /    |    \\___ \ \___ \\  ___/|  | \/|  |
;; \____|__  /____  >____  >\___  >__|   |__|
;;         \/     \/     \/     \/

(def ^:private spec
  [:map
   [:dsn {:title "DSN Url"
          :description "Sentry DSN Endpoint"
          :json-schema/example "http://foo@bar.sentry"} #'HttpUrl]])

(defmethod ig/assert-key :component/sentry
  [_ system]
  (assert (m/validate spec system)
          (m/explain spec system)))
;; .___       .__  __
;; |   | ____ |__|/  |_
;; |   |/    \|  \   __\
;; |   |   |  \  ||  |
;; |___|___|  /__||__|
;;          \/

(defmethod ig/init-key :component/sentry
  [_ {:keys [dsn] :as sys}]
  (log/infof "starting sentry component with dsn %s" dsn)
  (let [executor (knit/executor
                  :single
                  {:thread-factory (knit/thread-factory {:thread-group (knit/thread-group "sentry")
                                                         :daemon true})})]
    (assoc sys :executor executor
           :send-ex-fn! (partial lib/send-exception dsn))))

;;   ___ ___        .__   __
;;  /   |   \_____  |  |_/  |_
;; /    ~    \__  \ |  |\   __\
;; \    Y    // __ \|  |_|  |
;;  \___|_  /(____  /____/__|
;;        \/      \/

(defmethod ig/halt-key! :component/sentry
  [_ {:keys [executor] :as system}]
  (log/info "stopping sentry component")
  (when executor
    (.shutdown ^ExecutorService executor))
  system)
