(ns commons.normalizer)

(defn normalize-keywords [doc]
  "Normalize keys from JSON format"
  {:added "0.0.3"}
  (reduce-kv
   (fn [m k v]
     (assoc m (keyword (string/replace (name k) #"_" "-")) v))
   {}
   doc))


;;; Formats

(defn- camelcase-to-delimitered [k delimeter]
  (->> (clojure.string/split k #"(?=[A-Z])")
       (map clojure.string/lower-case)
       (clojure.string/join delimeter)))

(defn camel->dash
  "Convert Camel key to dash one"
  [key]
  {:added "0.0.3"}
  (-> key
      (camelcase-to-delimitered "-")
      (keyword)))
