(ns commons.components.logging
  "Common logging component"
  {:added "0.0.3"}
  (:require [integrant.core :as ig]
            [clojure.tools.logging :as log])
  (:import [org.slf4j LoggerFactory]
           [ch.qos.logback.classic Logger]))


(defonce ex-handler
  ;; Exception Handler
  (reify Thread$UncaughtExceptionHandler
    (uncaughtException [_ t e]
      (log/error e "Uncaught exception in" (.getName t)))))


(def config {:component/logging
             {:console {:encoder :pattern
                        :pattern "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n"}
              :level :info
              :app-lever :info
              :overrides {"pedestal-tools" :debug
                          "org.apache.kafka" :info}}})


(defn get-logger ^Logger [app]
  ;; Factory wrapper for extension purpose.
  ;; Using the stock one at the moment
  (LoggerFactory/getLogger (name app)))


(defmethod ig/init-key :component/logging
  [_ {:keys [app-name app-level] :as sys}]
  (when-not app-name
    (throw (ex-info "No application name specified in logging"
                    {:logging sys})))
  (let [cfg (cond-> sys
              app-level (update :overrides assoc (name app-name) app-level))]
    (Thread/setDefaultUncaughtExceptionHandler ex-handler)
    (assoc sys :logger (get-logger app-name))))
