(ns commons.collections
  (:require [clojure.set :refer [index]]))

(defn filter-by-presence
  "Filter a sequence of maps by the
   submap presence defined in x parameter.
   Return a vector.

  (filter-by-presence [{:foo 1 :bar 2}]
                      {:foo 1}) ;; => {:foo 1 :bar 2}

  (filter-by-presence [{:foo 1 :bar 2}]
                      {:foo 4}) ;; => []
  "
  {:added "0.1.0"}
  [coll x]
  (if (empty? x)
    coll
    (->
     ((index coll (keys x)) x)
     vec)))


(defn- local-merge
  [{:keys [merge-colls
           scalar-into-coll]
    :or {scalar-into-coll false
         merge-colls true}
    :as opts} a b]
  {:added "0.0.3"}
  (cond
    (nil? a)                        b
    (nil? b)                        a
    (and (map? a) (map? b))         (merge-with (partial local-merge opts) a b)
    (and merge-colls
         (coll? a) (coll? b))       (into a b)
    (and scalar-into-coll
         (coll? a) (not (coll? b))) (conj a b)
    :else                           b))


(defn deep-merge-with-opts
  "Deep Merge objects with parameters"
  {:added "0.0.3"}
  ([merge-opts] nil)
  ([merge-opts obj & objs]
   (reduce (partial local-merge merge-opts) obj objs)))


(defn deep-merge
  "Deep merge collections"
  {:added "0.0.3"}
  [& objs]
  (apply deep-merge-with-opts {} objs))


(defn distinct-by
  "Distinct collection by predicate

  Example:
    (distinct-by :email
             [{:name 1 :email 1 }
              {:name 2 :email 2 }
              {:name 3 :email 2 }])

  ;; [{:name 1 :email 1 } {:name 2 :email 2 }]
  "
  [f coll]
  {:added "0.0.3"}
  (let [groups (group-by f coll)]
    (map #(first (groups %)) (distinct (map f coll)))))


(defn ^:private update-some [m k f]
  "Update key if exists else yield
   current hashmap."
  {:added "0.0.3"}
  (if (some? (k m))
    (update m k f)
    m))
