(defproject io.trosa/commons "0.0.3"
  :description "Iomonad's commons library"
  :url "https://github.com/iomonad/commons"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/tools.logging "0.5.0"]
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [integrant "0.8.0"]
                 [org.apache.kafka/kafka-clients "2.7.0"]
                 [org.apache.kafka/kafka_2.12 "2.7.0"]
                 [metosin/jsonista "0.3.3"]]
  :min-lein-version "2.5.3"
  :profiles {:dev {:dependencies [[org.clojure/tools.namespace "0.3.1"]
                                  [io.pedestal/pedestal.service-tools "0.5.7"]
                                  [integrant/repl "0.3.1"]]
                   :source-paths ["dev"]
                   :resource-paths ["resources" "dev-resources"]}
             :uber {:aot :all}}
  :deploy-repositories [["clojars"
                         {:url "https://clojars.org/repo"
                          :username :env/clojars_username
                          :password  :env/clojars_password
                          :sign-releases false}]])
