/*
 * Decompiled with CFR 0.152.
 */
package momentum.http;

import clojure.lang.IFn;
import java.util.LinkedList;
import java.util.List;
import momentum.buffer.Buffer;
import momentum.http.WsFrame;
import momentum.http.WsFrameType;

public class WsFrameDecoder {
    State cs = State.OP_CODE;
    WsFrame cf;
    final IFn cb;
    int length;
    int remaining;
    final List<Buffer> chunks;
    int maskOffset;
    final boolean requireMask;

    public WsFrameDecoder(boolean mask, IFn callback) {
        this.cb = callback;
        this.chunks = new LinkedList<Buffer>();
        this.requireMask = mask;
    }

    public void decode(Buffer buf) throws Exception {
        try {
            while (buf.hasRemaining()) {
                switch (this.cs) {
                    case OP_CODE: {
                        byte b = buf.get();
                        this.cf = new WsFrame();
                        this.maskOffset = 0;
                        this.cf.isFinal(128 == (b & 0x80));
                        this.cf.type(this.getType(b & 0xF));
                        this.cs = State.LENGTH;
                        break;
                    }
                    case LENGTH: {
                        boolean isMasked;
                        byte b = buf.get();
                        boolean bl = isMasked = 128 == (b & 0x80);
                        if (this.requireMask && !isMasked) {
                            throw new RuntimeException("Mask is required, but none set.");
                        }
                        this.cf.isMasked(isMasked);
                        this.length = b & 0x7F;
                        if (this.length == 127) {
                            this.remaining = 8;
                            this.length = 0;
                            this.cs = State.LENGTH_EXT;
                            break;
                        }
                        if (this.length == 126) {
                            this.remaining = 2;
                            this.length = 0;
                            this.cs = State.LENGTH_EXT;
                            break;
                        }
                        if (this.cf.isMasked()) {
                            this.remaining = 4;
                            this.cs = State.MASK_KEY;
                            break;
                        }
                        if (this.length > 0) {
                            if (this.cf.isClose()) {
                                if (this.length == 1) {
                                    throw new RuntimeException("Invalid payload size for close frame");
                                }
                                this.remaining = 2;
                                this.cs = State.STATUS_CODE;
                                break;
                            }
                            this.remaining = this.length;
                            this.cs = State.PAYLOAD;
                            break;
                        }
                        this.finalizeFrame();
                        break;
                    }
                    case LENGTH_EXT: {
                        --this.remaining;
                        this.length *= 10;
                        this.length += buf.get() & 0xFF;
                        if (this.remaining != 0) break;
                        if (this.cf.isMasked()) {
                            this.remaining = 4;
                            this.cs = State.MASK_KEY;
                            break;
                        }
                        if (this.cf.isClose()) {
                            this.remaining = 2;
                            this.cs = State.STATUS_CODE;
                            break;
                        }
                        this.remaining = this.length;
                        this.cs = State.PAYLOAD;
                        break;
                    }
                    case MASK_KEY: {
                        --this.remaining;
                        this.cf.maskingKey <<= 8;
                        this.cf.maskingKey |= buf.getUnsigned();
                        if (this.remaining != 0) break;
                        if (this.length > 0 && this.cf.isClose()) {
                            if (this.length == 1) {
                                throw new RuntimeException("Invalid payload size for close frame");
                            }
                            this.remaining = 2;
                            this.cs = State.STATUS_CODE;
                            break;
                        }
                        if (this.length > 0) {
                            this.remaining = this.length;
                            this.cs = State.PAYLOAD;
                            break;
                        }
                        this.finalizeFrame();
                        break;
                    }
                    case STATUS_CODE: {
                        --this.remaining;
                        this.cf.statusCode <<= 8;
                        this.cf.statusCode |= buf.getUnsigned();
                        if (this.remaining != 0) break;
                        if (this.cf.isMasked()) {
                            this.cf.statusCode ^= this.cf.maskingKey >>> 16 & 0xFFFF;
                        }
                        this.remaining = this.length - 2;
                        if (this.remaining > 0) {
                            this.cs = State.PAYLOAD;
                            break;
                        }
                        this.finalizeFrame();
                        break;
                    }
                    case PAYLOAD: {
                        int chunkSize = Math.min(this.remaining, buf.remaining());
                        this.chunks.add(this.mask(buf.slice(buf.position(), chunkSize)));
                        buf.skip(chunkSize);
                        this.remaining -= chunkSize;
                        if (this.remaining != 0) break;
                        this.finalizeFrame();
                        break;
                    }
                    case ERROR: {
                        throw new RuntimeException("The WS stream is invalid");
                    }
                }
            }
        }
        catch (RuntimeException err) {
            this.cs = State.ERROR;
            throw err;
        }
    }

    private void finalizeFrame() throws Exception {
        if (!this.chunks.isEmpty()) {
            this.cf.payload(Buffer.wrap(this.chunks));
            this.chunks.clear();
        }
        this.cb.invoke((Object)this.cf);
        this.cs = State.OP_CODE;
    }

    private Buffer mask(Buffer buf) {
        int len;
        if (!this.cf.isMasked) {
            return buf;
        }
        int mask = Integer.rotateLeft(this.cf.maskingKey, 8 * this.maskOffset);
        int pos = buf.position();
        for (len = buf.remaining(); len >= 4; len -= 4) {
            buf.putInt(pos, mask ^ buf.getInt(pos));
            pos += 4;
        }
        this.maskOffset = (this.maskOffset + len) % 4;
        if (len-- > 0) {
            buf.put(pos, mask >>> 24 & 0xFF ^ buf.get(pos));
            ++pos;
            if (len-- > 0) {
                buf.put(pos, mask >>> 16 & 0xFF ^ buf.get(pos));
                ++pos;
                if (len > 0) {
                    buf.put(pos, mask >>> 8 & 0xFF ^ buf.get(pos));
                }
            }
        }
        return buf;
    }

    private WsFrameType getType(int opcode) {
        switch (opcode) {
            case 0: {
                return WsFrameType.CONTINUATION;
            }
            case 1: {
                return WsFrameType.TEXT;
            }
            case 2: {
                return WsFrameType.BINARY;
            }
            case 8: {
                return WsFrameType.CLOSE;
            }
            case 9: {
                return WsFrameType.PING;
            }
            case 10: {
                return WsFrameType.PONG;
            }
        }
        throw new RuntimeException("Unknown type: " + opcode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        OP_CODE,
        LENGTH,
        LENGTH_EXT,
        MASK_KEY,
        STATUS_CODE,
        PAYLOAD,
        ERROR;

    }
}

