/*
 * Decompiled with CFR 0.152.
 */
package momentum.buffer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import momentum.buffer.Buffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeBuffer
extends Buffer {
    private static int MIN_IDX_ARR_LEN = 10;
    Buffer[] bufs;
    int[] indices;
    int currentCapacity;
    int lastBufferIdx;
    int bufCount;

    protected static Buffer build(Buffer[] bufArr, int capacity) {
        int size = Math.max(MIN_IDX_ARR_LEN, bufArr.length * 2);
        Buffer[] bufs = new Buffer[size];
        int[] indices = new int[size];
        for (int i = 0; i < bufArr.length; ++i) {
            Buffer buf;
            bufs[i] = buf = bufArr[i];
            indices[i + 1] = indices[i] + buf.capacity;
        }
        capacity = Math.max(capacity, indices[bufArr.length]);
        return new CompositeBuffer(bufs, indices, bufArr.length, 0, capacity, capacity, true);
    }

    protected CompositeBuffer(Buffer[] bs, int[] idxs, int cnt, int pos, int lim, int cap, boolean be) {
        super(pos, lim, cap, be);
        this.bufs = bs;
        this.indices = idxs;
        this.bufCount = cnt;
        this.currentCapacity = idxs[cnt];
    }

    @Override
    protected HashMap<String, String> toStringAttrs() {
        HashMap<String, String> ret = super.toStringAttrs();
        ret.put("parts", Integer.toString(this.bufCount));
        ret.put("allocated", Integer.toString(this.currentCapacity));
        return ret;
    }

    @Override
    protected ByteBuffer _toByteBuffer() {
        if (this.bufCount == 1) {
            return this.bufs[0]._toByteBuffer();
        }
        return super._toByteBuffer();
    }

    @Override
    protected ChannelBuffer _toChannelBuffer() {
        ByteBuffer[] arr = new ByteBuffer[this.bufCount];
        for (int i = 0; i < this.bufCount; ++i) {
            ByteBuffer curr = this.bufs[i]._toByteBuffer();
            curr.order(this.order());
            arr[i] = curr;
        }
        ChannelBuffer ret = ChannelBuffers.wrappedBuffer((ByteBuffer[])arr);
        if (ret.capacity() > this.capacity) {
            ret.writerIndex(this.capacity);
            ret = ret.slice();
        }
        return ret;
    }

    @Override
    protected byte[] _toByteArray() {
        if (this.bufCount == 1 && this.capacity == this.bufs[0].capacity) {
            return this.bufs[0]._toByteArray();
        }
        int size = Math.min(this.currentCapacity, this.capacity);
        byte[] arr = new byte[size];
        this._get(0, arr, 0, size);
        return arr;
    }

    @Override
    protected Buffer _slice(int idx, int len) {
        if (idx == 0 && len == this.capacity) {
            new CompositeBuffer(this.dupBufs(), this.dupIndices(), this.bufCount, 0, len, len, this.bigEndian);
        } else if (idx >= this.currentCapacity) {
            return Buffer.dynamic(0, len).order(this.order());
        }
        int start = this.bufferIndex(idx);
        int offset = idx - this.indices[start];
        if (len <= this.indices[start + 1] - this.indices[start] - offset) {
            return this.bufs[start]._slice(offset, len).order(this.order());
        }
        if (len <= 256) {
            byte[] arr = new byte[len];
            this._get(idx, arr, 0, len);
            return Buffer.wrap(arr).order(this.order());
        }
        Buffer[] newBufs = new Buffer[this.bufs.length];
        int[] newIndices = new int[this.indices.length];
        Buffer curr = this.bufs[start];
        newBufs[0] = curr = curr._slice(offset, curr.capacity - offset);
        newIndices[1] = curr.capacity;
        int cnt = 1;
        while (cnt != this.bufCount && newIndices[cnt] < len) {
            curr = this.bufs[start + cnt];
            int cap = newIndices[cnt] + curr.capacity;
            if (cap > len) {
                curr = curr._slice(0, len - newIndices[cnt]);
                cap = len;
            }
            newBufs[cnt] = curr;
            newIndices[++cnt] = cap;
        }
        return new CompositeBuffer(newBufs, newIndices, cnt, 0, len, len, this.bigEndian);
    }

    @Override
    protected byte _get(int idx) {
        if (idx >= this.currentCapacity) {
            return 0;
        }
        int bufIdx = this.bufferIndex(idx);
        Buffer curr = this.bufs[bufIdx];
        return curr.get(idx - this.indices[bufIdx]);
    }

    @Override
    public void _get(int idx, byte[] dst, int off, int len) {
        if (idx >= this.currentCapacity) {
            Arrays.fill(dst, off, off + len, (byte)0);
            return;
        }
        int bufIdx = this.bufferIndex(idx);
        while (len > 0) {
            int nextIdx = this.indices[bufIdx + 1];
            int chunk = Math.min(nextIdx - idx, len);
            Buffer curr = this.bufs[bufIdx];
            curr._get(idx - this.indices[bufIdx], dst, off, chunk);
            idx = nextIdx;
            off += chunk;
            len -= chunk;
            if (idx >= this.currentCapacity) {
                Arrays.fill(dst, off, off + len, (byte)0);
                return;
            }
            ++bufIdx;
        }
    }

    @Override
    protected void _put(int idx, byte b) {
        int bufIdx = idx >= this.currentCapacity ? this.growTo(idx, 1) : this.bufferIndex(idx);
        Buffer curr = this.bufs[bufIdx];
        curr.put(idx - this.indices[bufIdx], b);
    }

    @Override
    public void _put(int idx, byte[] src, int off, int len) {
        int bufIdx;
        if (idx >= this.currentCapacity) {
            bufIdx = this.growTo(idx, len);
        } else {
            if (idx + len > this.currentCapacity) {
                this.growTo(idx, len);
            }
            bufIdx = this.bufferIndex(idx);
        }
        while (len > 0) {
            int nextIdx = this.indices[bufIdx + 1];
            int chunk = Math.min(nextIdx - idx, len);
            Buffer curr = this.bufs[bufIdx];
            curr._put(idx - this.indices[bufIdx], src, off, chunk);
            idx = nextIdx;
            off += chunk;
            len -= chunk;
            ++bufIdx;
        }
    }

    private int bufferIndex(int idx) {
        int bufIdx;
        this.lastBufferIdx = bufIdx = this.peekBufferIndex(idx);
        return bufIdx;
    }

    private int peekBufferIndex(int idx) {
        if (idx < 0 || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        int bufferIdx = this.lastBufferIdx;
        if (idx >= this.indices[bufferIdx]) {
            if (idx < this.indices[bufferIdx + 1]) {
                return bufferIdx;
            }
            while (this.indices[++bufferIdx + 1] < idx) {
            }
        } else {
            while (this.indices[--bufferIdx] > idx) {
            }
        }
        return bufferIdx;
    }

    private int growTo(int idx, int padding) {
        int newCapacity = Math.max(idx + padding, this.currentCapacity * 2);
        if (this.bufCount == this.bufs.length) {
            this.bufs = Arrays.copyOf(this.bufs, this.bufs.length + 10);
            this.indices = Arrays.copyOf(this.indices, this.indices.length + 10 + 1);
        }
        this.bufs[this.bufCount] = Buffer.allocate(newCapacity - this.currentCapacity);
        this.indices[this.bufCount + 1] = newCapacity;
        this.currentCapacity = newCapacity;
        this.lastBufferIdx = this.bufCount;
        return this.bufCount++;
    }

    private Buffer[] dupBufs() {
        return Arrays.copyOf(this.bufs, this.bufs.length);
    }

    private int[] dupIndices() {
        return Arrays.copyOf(this.indices, this.indices.length);
    }
}

