/*
 * Decompiled with CFR 0.152.
 */
package momentum.buffer;

import clojure.lang.ISeq;
import clojure.lang.PersistentList;
import clojure.lang.Seqable;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import momentum.buffer.BufferBackedBuffer;
import momentum.buffer.ByteBufferBackedBuffer;
import momentum.buffer.ChannelBufferBackedBuffer;
import momentum.buffer.CompositeBuffer;
import momentum.buffer.HeapBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Buffer
implements Seqable {
    static final int MIN_DYNAMIC_BUFFER_SIZE = 64;
    int position;
    int limit;
    int capacity;
    boolean bigEndian;

    public static final Buffer allocate(int cap) {
        return Buffer.wrapArray(new byte[cap], 0, cap);
    }

    public static final Buffer allocateDirect(int cap) {
        return Buffer.wrap(ByteBuffer.allocateDirect(cap));
    }

    public static final Buffer wrapDynamic(Buffer buf, int max) {
        return CompositeBuffer.build(new Buffer[]{buf.slice()}, max);
    }

    public static final Buffer wrapDynamic(Buffer[] bufs, int max) {
        for (int i = 0; i < bufs.length; ++i) {
            bufs[i] = bufs[i].slice();
        }
        return CompositeBuffer.build(bufs, max);
    }

    public static final Buffer wrapDynamic(Collection<Object> objs, int max) throws UnsupportedEncodingException {
        Buffer[] bufs = new Buffer[objs.size()];
        Iterator<Object> iterator = objs.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            bufs[i] = Buffer.wrap(iterator.next());
            ++i;
        }
        return CompositeBuffer.build(bufs, max);
    }

    public static final Buffer dynamic() {
        return Buffer.dynamic(1024, Integer.MAX_VALUE);
    }

    public static final Buffer dynamic(int est) {
        return Buffer.dynamic(est, Integer.MAX_VALUE);
    }

    public static final Buffer dynamic(int est, int max) {
        Buffer[] arr = est == 0 ? new Buffer[]{} : (est < 64 && max >= 64 ? new Buffer[]{Buffer.allocate(64)} : new Buffer[]{Buffer.allocate(est)});
        return CompositeBuffer.build(arr, max);
    }

    public static final Buffer wrap(byte[] arr) {
        return Buffer.wrapArray(arr, 0, arr.length);
    }

    public static final Buffer wrapArray(byte[] arr, int offset, int len) {
        return new HeapBuffer(arr, offset, 0, len, len);
    }

    public static final Buffer wrap(ByteBuffer buf) {
        if (buf.hasArray()) {
            return Buffer.wrapArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        }
        return new ByteBufferBackedBuffer(buf.slice());
    }

    public static final Buffer wrap(ChannelBuffer buf) {
        if ((buf = buf.slice()).hasArray()) {
            return Buffer.wrapArray(buf.array(), buf.arrayOffset() + buf.readerIndex(), buf.readableBytes());
        }
        return new ChannelBufferBackedBuffer(buf);
    }

    public static final Buffer wrap(Buffer buf) {
        return buf.slice();
    }

    public static final Buffer wrap(String str) throws UnsupportedEncodingException {
        return Buffer.wrap(str.getBytes("UTF-8"));
    }

    public static final Buffer wrap(Buffer[] bufs) {
        if (bufs.length == 0) {
            return Buffer.allocate(0);
        }
        if (bufs.length == 1) {
            return Buffer.wrap(bufs[0]);
        }
        return Buffer.wrapDynamic(bufs, 0);
    }

    public static final Buffer wrap(Collection<Object> objs) throws UnsupportedEncodingException {
        if (objs.size() == 0) {
            return Buffer.allocate(0);
        }
        if (objs.size() == 1) {
            Iterator<Object> i = objs.iterator();
            return Buffer.wrap(i.next());
        }
        return Buffer.wrapDynamic(objs, 0);
    }

    public static final Buffer wrap(Object obj) throws UnsupportedEncodingException {
        if (obj instanceof Buffer) {
            return Buffer.wrap((Buffer)obj);
        }
        if (obj instanceof ByteBuffer) {
            return Buffer.wrap((ByteBuffer)obj);
        }
        if (obj instanceof ChannelBuffer) {
            return Buffer.wrap((ChannelBuffer)obj);
        }
        if (obj instanceof Collection) {
            return Buffer.wrap((Collection)obj);
        }
        if (obj instanceof byte[]) {
            return Buffer.wrap((byte[])obj);
        }
        if (obj instanceof String) {
            return Buffer.wrap((String)obj);
        }
        if (obj instanceof Integer) {
            Integer n = (Integer)obj;
            return Buffer.wrap(n);
        }
        if (obj instanceof Long) {
            Long n = (Long)obj;
            return Buffer.wrap(n);
        }
        String msg = "Object " + obj + "(" + obj.getClass() + ") not bufferable";
        throw new IllegalArgumentException(msg);
    }

    public static final Buffer wrap(int n) {
        return Buffer.allocate(4).putIntBigEndian(0, n);
    }

    public static final Buffer wrap(long n) {
        if (n > Long.MIN_VALUE && n < Long.MAX_VALUE) {
            return Buffer.allocate(4).putIntBigEndian(0, (int)n);
        }
        return Buffer.allocate(8).putLongBigEndian(0, n);
    }

    public static final Buffer wrap(Object o1, Object o2) throws UnsupportedEncodingException {
        return Buffer.wrap(Arrays.asList(o1, o2));
    }

    public static final Buffer wrap(Object o1, Object o2, Object o3) throws UnsupportedEncodingException {
        return Buffer.wrap(Arrays.asList(o1, o2, o3));
    }

    public static final Buffer wrap(Object o1, Object o2, Object o3, Object o4) throws UnsupportedEncodingException {
        return Buffer.wrap(Arrays.asList(o1, o2, o3, o4));
    }

    public static final Buffer wrap(Object o1, Object o2, Object o3, Object o4, Object o5) throws UnsupportedEncodingException {
        return Buffer.wrap(Arrays.asList(o1, o2, o3, o4, o5));
    }

    public static final Buffer wrap(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) throws UnsupportedEncodingException {
        return Buffer.wrap(Arrays.asList(o1, o2, o3, o4, o5, o6));
    }

    protected Buffer(int pos, int lim, int cap, boolean be) {
        if (cap < 0) {
            throw new IllegalArgumentException("Negative capacity: " + cap);
        }
        this.capacity = cap;
        this.bigEndian = be;
        this.limit(lim);
        this.position(pos);
    }

    public final int capacity() {
        return this.capacity;
    }

    public final Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        return this;
    }

    public final Buffer duplicate() {
        return this._slice(0, this.capacity);
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        return this;
    }

    public final boolean equals(Buffer o) {
        int remaining = this.remaining();
        if (o.remaining() != remaining) {
            return false;
        }
        int indexA = this.position;
        int indexB = o.position;
        while (remaining-- > 0) {
            if (this._get(indexA) != o._get(indexB)) {
                return false;
            }
            ++indexA;
            ++indexB;
        }
        return true;
    }

    public final boolean equals(Object o) {
        if (o instanceof Buffer) {
            return this.equals((Buffer)o);
        }
        return false;
    }

    public final Buffer focus(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        this.limit(this.position + len);
        return this;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int newLimit) {
        if (newLimit > this.capacity || newLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        return this;
    }

    public final ByteOrder order() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public final Buffer order(ByteOrder order) {
        this.bigEndian = order == ByteOrder.BIG_ENDIAN;
        return this;
    }

    public final int position() {
        return this.position;
    }

    public final Buffer position(int newPosition) {
        if (newPosition > this.limit || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        return this;
    }

    public final ISeq seq() {
        return new PersistentList((Object)this);
    }

    public final Buffer skip(int len) {
        this.position(this.position + len);
        return this;
    }

    protected Buffer _slice(int idx, int len) {
        return new BufferBackedBuffer(this, idx, 0, len, len, this.bigEndian);
    }

    public final Buffer slice() {
        return this._slice(this.position, this.remaining());
    }

    public final Buffer slice(int idx, int len) {
        if (idx < 0 || idx > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (len < 0 || idx + len > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        return this._slice(idx, len);
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final Buffer rewind() {
        this.position = 0;
        return this;
    }

    protected HashMap<String, String> toStringAttrs() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("pos", Integer.toString(this.position));
        ret.put("lim", Integer.toString(this.limit));
        ret.put("cap", Integer.toString(this.capacity));
        return ret;
    }

    public final String toString() {
        String str = this.getClass().getSimpleName();
        str = str + "#" + Integer.toHexString(System.identityHashCode(this));
        str = str + this.toStringAttrs().toString();
        return str;
    }

    public final Buffer window(int pos, int len) {
        return this.position(pos).limit(pos + len);
    }

    protected byte[] _toByteArray() {
        byte[] arr = new byte[this.capacity];
        this._get(0, arr, 0, this.capacity);
        return arr;
    }

    protected ByteBuffer _toByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray());
    }

    protected ChannelBuffer _toChannelBuffer() {
        return ChannelBuffers.wrappedBuffer((ByteBuffer)this._toByteBuffer());
    }

    public final ByteBuffer toByteBuffer() {
        ByteBuffer ret = this._toByteBuffer();
        ret.position(this.position);
        ret.limit(this.limit);
        ret.order(this.order());
        return ret;
    }

    public final ChannelBuffer toChannelBuffer() {
        ChannelBuffer ret = this._toChannelBuffer();
        ret.setIndex(this.position, this.limit);
        return ret;
    }

    public final byte[] toByteArray() {
        return this._toByteArray();
    }

    public final String toString(String charsetName) throws UnsupportedEncodingException {
        byte[] arr = new byte[this.remaining()];
        this._get(this.position, arr, 0, arr.length);
        return new String(arr, charsetName);
    }

    protected abstract byte _get(int var1);

    protected abstract void _put(int var1, byte var2);

    protected void _get(int idx, byte[] dst, int off, int len) {
        for (int i = 0; i < len; ++i) {
            dst[off + i] = this._get(idx + i);
        }
    }

    protected void _put(int idx, byte[] src, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this._put(idx + i, src[off + i]);
        }
    }

    protected void _put(int idx, Buffer src, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this._put(idx + i, src._get(off + i));
        }
    }

    public final Buffer get(Buffer dst) {
        int remaining = this.remaining();
        if (remaining == 0) {
            return this;
        }
        if (dst.remaining() < remaining) {
            throw new BufferOverflowException();
        }
        dst._put(dst.position, this, this.position, remaining);
        this.position += remaining;
        dst.position += remaining;
        return this;
    }

    public final Buffer get(Buffer dst, int off) {
        return this.get(dst, off, this.remaining());
    }

    public final Buffer get(Buffer dst, int off, int len) {
        int remaining = this.remaining();
        if (remaining < len) {
            throw new BufferUnderflowException();
        }
        if (dst.capacity < off + len) {
            throw new IndexOutOfBoundsException();
        }
        dst._put(off, this, this.position, len);
        this.position += len;
        return this;
    }

    public final Buffer get(int idx, Buffer dst, int off, int len) {
        if (this.capacity < idx + len) {
            throw new BufferUnderflowException();
        }
        if (dst.capacity < off + len) {
            throw new BufferOverflowException();
        }
        dst._put(off, this, idx, len);
        return this;
    }

    public final Buffer put(Buffer src) {
        int len = src.remaining();
        this.put(this.position, src, src.position, len);
        this.position += len;
        src.position += len;
        return this;
    }

    public final Buffer put(Buffer src, int off) {
        return this.put(src, off, this.remaining());
    }

    public final Buffer put(Buffer src, int off, int len) {
        this.put(this.position, src, off, len);
        this.position += len;
        return this;
    }

    public final Buffer put(int idx, Buffer src, int off, int len) {
        if (this.capacity < idx + len) {
            throw new BufferUnderflowException();
        }
        if (src.capacity < off + len) {
            throw new BufferOverflowException();
        }
        this._put(idx, src, off, len);
        return this;
    }

    public final byte get() {
        this.assertWalkable(1);
        byte retval = this.get(this.position);
        ++this.position;
        return retval;
    }

    public final int getUnsigned() {
        return this.get() & 0xFF;
    }

    public final byte get(int idx) {
        if (idx < 0 || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        return this._get(idx);
    }

    public final int getUnsigned(int idx) {
        return this.get(idx) & 0xFF;
    }

    public final Buffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public final Buffer get(byte[] dst, int offset, int len) {
        this.assertWalkable(len);
        this._get(this.position, dst, offset, len);
        this.position += len;
        return this;
    }

    public final Buffer get(int idx, byte[] dst, int offset, int len) {
        if (idx + len > this.capacity) {
            throw new BufferUnderflowException();
        }
        if (idx < 0 || offset + len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        this._get(idx, dst, offset, len);
        return this;
    }

    public final Buffer get(int idx, byte[] dst) {
        return this.get(idx, dst, 0, dst.length);
    }

    public final Buffer put(byte b) {
        this.assertWalkable(1);
        this._put(this.position, b);
        ++this.position;
        return this;
    }

    public final Buffer put(int b) {
        return this.put((byte)b);
    }

    public final Buffer putUnsigned(int b) {
        return this.put((byte)(b & 0xFF));
    }

    public final Buffer put(int idx, byte b) {
        if (idx < 0 || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this._put(idx, b);
        return this;
    }

    public final Buffer put(int idx, int b) {
        return this.put(idx, (byte)b);
    }

    public final Buffer putUnsigned(int idx, int b) {
        return this.put(idx, (byte)(b & 0xFF));
    }

    public final Buffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public final Buffer put(byte[] src, int offset, int len) {
        this.assertWalkable(len);
        this.put(this.position, src, offset, len);
        this.position += len;
        return this;
    }

    public final Buffer put(int idx, byte[] src, int offset, int len) {
        if (idx + len > this.capacity) {
            throw new BufferUnderflowException();
        }
        if (idx < 0 || offset + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        this._put(idx, src, offset, len);
        return this;
    }

    public final Buffer put(int idx, byte[] src) {
        return this.put(idx, src, 0, src.length);
    }

    private final char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    private final byte char1(char x) {
        return (byte)(x >> 8);
    }

    private final byte char0(char x) {
        return (byte)x;
    }

    public final char getChar() {
        return this.bigEndian ? this.getCharBigEndian() : this.getCharLittleEndian();
    }

    public final char getChar(int idx) {
        return this.bigEndian ? this.getCharBigEndian(idx) : this.getCharLittleEndian(idx);
    }

    public final char getCharBigEndian() {
        return this.getCharBigEndian(this.walking(2));
    }

    public final char getCharBigEndian(int idx) {
        return this.makeChar(this.get(idx), this.get(idx + 1));
    }

    public final char getCharLittleEndian() {
        return this.getCharLittleEndian(this.walking(2));
    }

    public final char getCharLittleEndian(int idx) {
        return this.makeChar(this.get(idx + 1), this.get(idx));
    }

    public final Buffer putChar(char val) {
        return this.bigEndian ? this.putCharBigEndian(val) : this.putCharLittleEndian(val);
    }

    public final Buffer putChar(int idx, char val) {
        return this.bigEndian ? this.putCharBigEndian(idx, val) : this.putCharLittleEndian(idx, val);
    }

    public final Buffer putCharBigEndian(char val) {
        return this.putCharBigEndian(this.walking(2), val);
    }

    public final Buffer putCharBigEndian(int idx, char val) {
        this.put(idx, this.char1(val));
        this.put(idx + 1, this.char0(val));
        return this;
    }

    public final Buffer putCharLittleEndian(char val) {
        return this.putCharLittleEndian(this.walking(2), val);
    }

    public final Buffer putCharLittleEndian(int idx, char val) {
        this.put(idx, this.char0(val));
        this.put(idx + 1, this.char1(val));
        return this;
    }

    public final double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public final double getDouble(int idx) {
        return Double.longBitsToDouble(this.getLong(idx));
    }

    public final double getDoubleBigEndian() {
        return Double.longBitsToDouble(this.getLongBigEndian());
    }

    public final double getDoubleBigEndian(int idx) {
        return Double.longBitsToDouble(this.getLongBigEndian(idx));
    }

    public final double getDoubleLittleEndian() {
        return Double.longBitsToDouble(this.getLongLittleEndian());
    }

    public final double getDoubleLittleEndian(int idx) {
        return Double.longBitsToDouble(this.getLongLittleEndian(idx));
    }

    public final Buffer putDouble(double val) {
        return this.putLong(Double.doubleToRawLongBits(val));
    }

    public final Buffer putDouble(int idx, double val) {
        return this.putLong(idx, Double.doubleToRawLongBits(val));
    }

    public final Buffer putDoubleBigEndian(double val) {
        return this.putLongBigEndian(Double.doubleToRawLongBits(val));
    }

    public final Buffer putDoubleBigEndian(int idx, double val) {
        return this.putLongBigEndian(idx, Double.doubleToRawLongBits(val));
    }

    public final Buffer putDoubleLittleEndian(double val) {
        return this.putLongLittleEndian(Double.doubleToRawLongBits(val));
    }

    public final Buffer putDoubleLittleEndian(int idx, double val) {
        return this.putLongLittleEndian(idx, Double.doubleToRawLongBits(val));
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public final float getFloat(int idx) {
        return Float.intBitsToFloat(this.getInt(idx));
    }

    public final float getFloatBigEndian() {
        return Float.intBitsToFloat(this.getIntBigEndian());
    }

    public final float getFloatBigEndian(int idx) {
        return Float.intBitsToFloat(this.getIntBigEndian(idx));
    }

    public final float getFloatLittleEndian() {
        return Float.intBitsToFloat(this.getIntLittleEndian());
    }

    public final float getFloatLittleEndian(int idx) {
        return Float.intBitsToFloat(this.getIntLittleEndian(idx));
    }

    public final Buffer putFloat(float val) {
        return this.putInt(Float.floatToRawIntBits(val));
    }

    public final Buffer putFloat(int idx, float val) {
        return this.putInt(idx, Float.floatToRawIntBits(val));
    }

    public final Buffer putFloatBigEndian(float val) {
        return this.putIntBigEndian(Float.floatToRawIntBits(val));
    }

    public final Buffer putFloatBigEndian(int idx, float val) {
        return this.putIntBigEndian(idx, Float.floatToRawIntBits(val));
    }

    public final Buffer putFloatLittleEndian(float val) {
        return this.putIntLittleEndian(Float.floatToRawIntBits(val));
    }

    public final Buffer putFloatLittleEndian(int idx, float val) {
        return this.putIntLittleEndian(idx, Float.floatToRawIntBits(val));
    }

    private final int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private final byte int3(int x) {
        return (byte)(x >> 24);
    }

    private final byte int2(int x) {
        return (byte)(x >> 16);
    }

    private final byte int1(int x) {
        return (byte)(x >> 8);
    }

    private final byte int0(int x) {
        return (byte)x;
    }

    public final int getInt() {
        return this.bigEndian ? this.getIntBigEndian() : this.getIntLittleEndian();
    }

    public final long getIntUnsigned() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    public final int getInt(int idx) {
        return this.bigEndian ? this.getIntBigEndian(idx) : this.getIntLittleEndian(idx);
    }

    public final long getIntUnsigned(int idx) {
        return (long)this.getInt(idx) & 0xFFFFFFFFL;
    }

    public final int getIntBigEndian() {
        return this.getIntBigEndian(this.walking(4));
    }

    public final long getIntUnsignedBigEndian() {
        return (long)this.getIntBigEndian() & 0xFFFFFFFFL;
    }

    public final int getIntBigEndian(int idx) {
        return this.makeInt(this.get(idx), this.get(idx + 1), this.get(idx + 2), this.get(idx + 3));
    }

    public final long getIntUnsignedBigEndian(int idx) {
        return (long)this.getIntBigEndian(idx) & 0xFFFFFFFFL;
    }

    public final int getIntLittleEndian() {
        return this.getIntLittleEndian(this.walking(4));
    }

    public final long getIntUnsignedLittleEndian() {
        return (long)this.getIntLittleEndian() & 0xFFFFFFFFL;
    }

    public final int getIntLittleEndian(int idx) {
        return this.makeInt(this.get(idx + 3), this.get(idx + 2), this.get(idx + 1), this.get(idx));
    }

    public final long getIntUnsignedLittleEndian(int idx) {
        return (long)this.getIntLittleEndian(idx) & 0xFFFFFFFFL;
    }

    public final Buffer putInt(int val) {
        return this.bigEndian ? this.putIntBigEndian(val) : this.putIntLittleEndian(val);
    }

    public final Buffer putIntUnsigned(long val) {
        return this.putInt((int)val);
    }

    public final Buffer putInt(int idx, int val) {
        return this.bigEndian ? this.putIntBigEndian(idx, val) : this.putIntLittleEndian(idx, val);
    }

    public final Buffer putIntUnsigned(int idx, long val) {
        return this.putInt(idx, (int)val);
    }

    public final Buffer putIntBigEndian(int val) {
        return this.putIntBigEndian(this.walking(4), val);
    }

    public final Buffer putIntUnsignedBigEndian(long val) {
        return this.putIntBigEndian((int)val);
    }

    public final Buffer putIntBigEndian(int idx, int val) {
        this.put(idx, this.int3(val));
        this.put(idx + 1, this.int2(val));
        this.put(idx + 2, this.int1(val));
        this.put(idx + 3, this.int0(val));
        return this;
    }

    public final Buffer putIntUnsignedBigEndian(int idx, long val) {
        return this.putIntBigEndian(idx, (int)val);
    }

    public final Buffer putIntLittleEndian(int val) {
        return this.putIntLittleEndian(this.walking(4), val);
    }

    public final Buffer putIntUnsignedLittleEndian(long val) {
        return this.putIntLittleEndian((int)val);
    }

    public final Buffer putIntLittleEndian(int idx, int val) {
        this.put(idx, this.int0(val));
        this.put(idx + 1, this.int1(val));
        this.put(idx + 2, this.int2(val));
        this.put(idx + 3, this.int3(val));
        return this;
    }

    public final Buffer putIntUnsignedLittleEndian(int idx, long val) {
        return this.putIntLittleEndian(idx, (int)val);
    }

    private final long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    private final byte long7(long x) {
        return (byte)(x >> 56);
    }

    private final byte long6(long x) {
        return (byte)(x >> 48);
    }

    private final byte long5(long x) {
        return (byte)(x >> 40);
    }

    private final byte long4(long x) {
        return (byte)(x >> 32);
    }

    private final byte long3(long x) {
        return (byte)(x >> 24);
    }

    private final byte long2(long x) {
        return (byte)(x >> 16);
    }

    private final byte long1(long x) {
        return (byte)(x >> 8);
    }

    private final byte long0(long x) {
        return (byte)x;
    }

    public final long getLong() {
        return this.bigEndian ? this.getLongBigEndian() : this.getLongLittleEndian();
    }

    public final long getLong(int idx) {
        return this.bigEndian ? this.getLongBigEndian(idx) : this.getLongLittleEndian(idx);
    }

    public final long getLongBigEndian() {
        return this.getLongBigEndian(this.walking(8));
    }

    public final long getLongBigEndian(int idx) {
        return this.makeLong(this.get(idx), this.get(idx + 1), this.get(idx + 2), this.get(idx + 3), this.get(idx + 4), this.get(idx + 5), this.get(idx + 6), this.get(idx + 7));
    }

    public final long getLongLittleEndian() {
        return this.getLongLittleEndian(this.walking(8));
    }

    public final long getLongLittleEndian(int idx) {
        return this.makeLong(this.get(idx + 7), this.get(idx + 6), this.get(idx + 5), this.get(idx + 4), this.get(idx + 3), this.get(idx + 2), this.get(idx + 1), this.get(idx));
    }

    public final Buffer putLong(long val) {
        return this.bigEndian ? this.putLongBigEndian(val) : this.putLongLittleEndian(val);
    }

    public final Buffer putLong(int idx, long val) {
        return this.bigEndian ? this.putLongBigEndian(idx, val) : this.putLongLittleEndian(idx, val);
    }

    public final Buffer putLongBigEndian(long val) {
        return this.putLongBigEndian(this.walking(8), val);
    }

    public final Buffer putLongBigEndian(int idx, long val) {
        this.put(idx, this.long7(val));
        this.put(idx + 1, this.long6(val));
        this.put(idx + 2, this.long5(val));
        this.put(idx + 3, this.long4(val));
        this.put(idx + 4, this.long3(val));
        this.put(idx + 5, this.long2(val));
        this.put(idx + 6, this.long1(val));
        this.put(idx + 7, this.long0(val));
        return this;
    }

    public final Buffer putLongLittleEndian(long val) {
        return this.putLongLittleEndian(this.walking(8), val);
    }

    public final Buffer putLongLittleEndian(int idx, long val) {
        this.put(idx, this.long0(val));
        this.put(idx + 1, this.long1(val));
        this.put(idx + 2, this.long2(val));
        this.put(idx + 3, this.long3(val));
        this.put(idx + 4, this.long4(val));
        this.put(idx + 5, this.long5(val));
        this.put(idx + 6, this.long6(val));
        this.put(idx + 7, this.long7(val));
        return this;
    }

    private final short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    private final byte short1(short x) {
        return (byte)(x >> 8);
    }

    private final byte short0(short x) {
        return (byte)x;
    }

    public final short getShort() {
        return this.bigEndian ? this.getShortBigEndian() : this.getShortLittleEndian();
    }

    public final int getShortUnsigned() {
        return this.getShort() & 0xFFFF;
    }

    public final short getShort(int idx) {
        return this.bigEndian ? this.getShortBigEndian(idx) : this.getShortLittleEndian(idx);
    }

    public final int getShortUnsigned(int idx) {
        return this.getShort(idx) & 0xFFFF;
    }

    public final short getShortBigEndian() {
        return this.getShortBigEndian(this.walking(2));
    }

    public final int getShortUnsignedBigEndian() {
        return this.getShortBigEndian() & 0xFFFF;
    }

    public final short getShortBigEndian(int idx) {
        return this.makeShort(this.get(idx), this.get(idx + 1));
    }

    public final int getShortUnsignedBigEndian(int idx) {
        return this.getShortBigEndian(idx) & 0xFFFF;
    }

    public final short getShortLittleEndian() {
        return this.getShortLittleEndian(this.walking(2));
    }

    public final int getShortUnsignedLittleEndian() {
        return this.getShortLittleEndian() & 0xFFFF;
    }

    public final short getShortLittleEndian(int idx) {
        return this.makeShort(this.get(idx + 1), this.get(idx));
    }

    public final int getShortUnsignedLittleEndian(int idx) {
        return this.getShortLittleEndian(idx) & 0xFFFF;
    }

    public final Buffer putShort(short val) {
        return this.bigEndian ? this.putShortBigEndian(val) : this.putShortLittleEndian(val);
    }

    public final Buffer putShortUnsigned(int val) {
        return this.putShort((short)val);
    }

    public final Buffer putShort(int idx, short val) {
        return this.bigEndian ? this.putShortBigEndian(idx, val) : this.putShortLittleEndian(idx, val);
    }

    public final Buffer putShortUnsigned(int idx, int val) {
        return this.putShort(idx, (short)val);
    }

    public final Buffer putShortBigEndian(short val) {
        return this.putShortBigEndian(this.walking(2), val);
    }

    public final Buffer putShortUnsignedBigEndian(int val) {
        return this.putShortBigEndian((short)val);
    }

    public final Buffer putShortBigEndian(int idx, short val) {
        this.put(idx, this.short1(val));
        this.put(idx + 1, this.short0(val));
        return this;
    }

    public final Buffer putShortUnsignedBigEndian(int idx, int val) {
        return this.putShortBigEndian(idx, (short)val);
    }

    public final Buffer putShortLittleEndian(short val) {
        return this.putShortLittleEndian(this.walking(2), val);
    }

    public final Buffer putShortUnsignedLittleEndian(int val) {
        return this.putShortLittleEndian((short)val);
    }

    public final Buffer putShortLittleEndian(int idx, short val) {
        this.put(idx, this.short0(val));
        this.put(idx + 1, this.short1(val));
        return this;
    }

    public final Buffer putShortUnsignedLittleEndian(int idx, int val) {
        return this.putShortLittleEndian(idx, (short)val);
    }

    private final void assertHolds(Buffer buf, int count) {
        if (buf.remaining() < count) {
            throw new BufferOverflowException();
        }
    }

    private final void assertWalkable(int count) {
        if (this.limit - this.position < count) {
            throw new BufferUnderflowException();
        }
    }

    private final int walking(int count) {
        this.assertWalkable(count);
        int retval = this.position;
        this.position += count;
        return retval;
    }
}

