/*
 * Decompiled with CFR 0.152.
 */
package momentum.async;

import clojure.lang.IFn;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import momentum.async.Async;
import momentum.async.JoinedArgs;
import momentum.async.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pipeline
extends Async<Object> {
    static final Stage FINAL = new Stage(null, null, null);
    final Stage head;
    final List<Catcher> catchers;
    final IFn finalizer;
    final AtomicReference<Stage> cs = new AtomicReference();

    public Pipeline(List<IFn> stages, List<Catcher> catchers, IFn finalizer) {
        Iterator<IFn> i = stages.iterator();
        Stage curr = null;
        while (i.hasNext()) {
            curr = new Stage(i.next(), curr, this);
        }
        this.head = curr;
        this.catchers = catchers;
        this.finalizer = finalizer;
    }

    public boolean put(Object v) {
        if (v instanceof Async) {
            Stage first = new Stage(null, this.head, this);
            if (!this.cs.compareAndSet(null, first)) {
                return false;
            }
            ((Async)((Object)v)).receive(first);
        } else if (this.head != null) {
            if (!this.cs.compareAndSet(null, this.head)) {
                return false;
            }
            this.head.put(v);
        } else {
            return this.success(v);
        }
        return true;
    }

    public boolean abort(Exception e) {
        return this.error(e);
    }

    public Object invoke(Object v) {
        return this.put(v);
    }

    boolean success(Object val) {
        Stage curr = this.cs.getAndSet(FINAL);
        if (curr == FINAL) {
            return false;
        }
        try {
            if (this.finalizer != null) {
                this.finalizer.invoke();
            }
            this.realizeSuccess(val);
        }
        catch (Exception err) {
            this.realizeError(err);
        }
        return true;
    }

    boolean error(Exception err) {
        Stage curr = this.cs.getAndSet(FINAL);
        if (curr == FINAL) {
            return false;
        }
        boolean caught = false;
        Object val = null;
        if (this.catchers != null) {
            try {
                for (Catcher c : this.catchers) {
                    if (!c.isMatch(err)) continue;
                    val = c.invoke(err);
                    caught = true;
                    break;
                }
            }
            catch (Exception e) {
                err = e;
            }
        }
        if (this.finalizer != null) {
            try {
                this.finalizer.invoke();
            }
            catch (Exception e) {
                caught = false;
                err = e;
            }
        }
        if (caught) {
            this.realizeSuccess(val);
        } else {
            this.realizeError(err);
        }
        return true;
    }

    static final class Stage
    implements Receiver {
        final IFn fn;
        final Stage next;
        final Pipeline pipeline;
        boolean recur;

        Stage(IFn fn, Stage next, Pipeline pipeline) {
            this.fn = fn;
            this.next = next;
            this.pipeline = pipeline;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void put(Object val) {
            try {
                while (true) {
                    block8: {
                        if ((val = val instanceof JoinedArgs ? this.fn.applyTo(((JoinedArgs)val).seq()) : this.fn.invoke(val)) instanceof Recur) {
                            this.recur = true;
                            val = ((Recur)val).val();
                        }
                        if (val instanceof Async) {
                            Async v = (Async)((Object)val);
                            if (this.recur && v.observe()) {
                                val = v.val;
                                break block8;
                            } else {
                                v.receive(this);
                                return;
                            }
                        }
                        if (!this.recur) {
                            this.success(val);
                            return;
                        }
                    }
                    this.recur = false;
                }
            }
            catch (Exception e) {
                this.error(e);
                return;
            }
        }

        public void success(Object val) {
            if (this.recur) {
                if (this.pipeline.cs.get() == this) {
                    this.recur = false;
                    this.put(val);
                }
            } else if (this.next != null) {
                if (this.pipeline.cs.compareAndSet(this, this.next)) {
                    this.next.put(val);
                }
            } else {
                this.pipeline.success(val);
            }
        }

        public void error(Exception err) {
            this.pipeline.error(err);
        }
    }

    public static class Recur {
        final Object val;

        public Recur(Object val) {
            this.val = val;
        }

        public Object val() {
            return this.val;
        }
    }

    public static class Catcher {
        final Class klass;
        final IFn callback;

        public Catcher(Class klass, IFn callback) {
            this.klass = klass;
            this.callback = callback;
        }

        public boolean isMatch(Exception err) {
            return this.klass.isInstance(err);
        }

        public Object invoke(Exception err) throws Exception {
            return this.callback.invoke((Object)err);
        }
    }
}

