/*
 * Decompiled with CFR 0.152.
 */
package momentum.async;

import clojure.lang.Counted;
import java.util.LinkedList;
import momentum.async.AsyncVal;

public class AsyncTransfer
implements Counted {
    final boolean hasDefault;
    final Object val;
    volatile LinkedList<Object> queuedValues = new LinkedList();
    final LinkedList<AsyncVal> queuedTransfers = new LinkedList();
    Exception err;

    public AsyncTransfer() {
        this.hasDefault = false;
        this.val = null;
    }

    public AsyncTransfer(Object v) {
        this.hasDefault = true;
        this.val = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        AsyncTransfer asyncTransfer = this;
        synchronized (asyncTransfer) {
            if (this.isClosed()) {
                return 0;
            }
            return this.queuedValues.size() - this.queuedTransfers.size();
        }
    }

    public boolean isClosed() {
        return this.queuedValues == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Object o) {
        AsyncVal dst = null;
        AsyncTransfer asyncTransfer = this;
        synchronized (asyncTransfer) {
            if (this.isClosed()) {
                return false;
            }
            if (this.queuedTransfers.size() > 0) {
                dst = this.queuedTransfers.poll();
            } else {
                this.queuedValues.offer(o);
            }
        }
        if (dst != null) {
            dst.put(o);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() throws Exception {
        AsyncTransfer asyncTransfer = this;
        synchronized (asyncTransfer) {
            if (this.isClosed()) {
                if (this.err != null) {
                    throw this.err;
                }
                return this.val;
            }
            if (this.queuedValues.size() > 0) {
                return this.queuedValues.poll();
            }
            AsyncVal placeholder = new AsyncVal();
            this.queuedTransfers.offer(placeholder);
            return placeholder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort(Exception e) {
        AsyncVal v;
        AsyncTransfer asyncTransfer = this;
        synchronized (asyncTransfer) {
            if (!this.doClose()) {
                return false;
            }
            this.err = e;
        }
        while ((v = this.queuedTransfers.poll()) != null) {
            v.abort(e);
        }
        return true;
    }

    public boolean close() {
        if (this.hasDefault) {
            return this.abort(new RuntimeException("The async transfer has been closed"));
        }
        if (this.doClose()) {
            AsyncVal v;
            while ((v = this.queuedTransfers.poll()) != null) {
                v.put(this.val);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doClose() {
        AsyncTransfer asyncTransfer = this;
        synchronized (asyncTransfer) {
            if (this.isClosed()) {
                return false;
            }
            this.queuedValues = null;
        }
        return true;
    }
}

