/*
 * Decompiled with CFR 0.152.
 */
package momentum.async;

import clojure.lang.AFn;
import clojure.lang.IBlockingDeref;
import clojure.lang.IDeref;
import clojure.lang.IPending;
import clojure.lang.Util;
import java.util.LinkedList;
import momentum.async.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Async<T>
extends AFn
implements IPending,
IDeref,
IBlockingDeref {
    volatile boolean isRealized;
    boolean isBlocked;
    T val;
    Exception err;
    final LinkedList<Receiver> receivers = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean realizeSuccess(T v) {
        Async async = this;
        synchronized (async) {
            if (this.isRealized) {
                return false;
            }
            this.val = v;
            this.isRealized = true;
            if (this.isBlocked) {
                ((Object)((Object)this)).notifyAll();
            }
        }
        this.deliverAll(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean realizeError(Exception e) {
        Async async = this;
        synchronized (async) {
            if (this.isRealized) {
                return false;
            }
            this.err = e;
            this.isRealized = true;
            if (this.isBlocked) {
                ((Object)((Object)this)).notifyAll();
            }
        }
        this.deliverAll(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive(Receiver r) {
        if (r == null) {
            throw new NullPointerException("Receiver is null");
        }
        if (!this.observe()) {
            Async async = this;
            synchronized (async) {
                if (!this.isRealized) {
                    this.receivers.add(r);
                    return;
                }
            }
        }
        this.deliver(r, this.err == null);
    }

    boolean observe() {
        return this.isRealized;
    }

    public final boolean isRealized() {
        return this.isRealized;
    }

    public final boolean isSuccessful() {
        return this.isRealized && this.err == null;
    }

    public final boolean isAborted() {
        return this.isRealized && this.err != null;
    }

    public final Object deref() {
        return this.deref(-1L, null);
    }

    public final Object deref(long ms, Object timeoutValue) {
        if (this.block(ms)) {
            if (this.err != null) {
                throw Util.runtimeException((Throwable)this.err);
            }
            return this.val;
        }
        return timeoutValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean block(long ms) {
        if (this.observe()) {
            return true;
        }
        if (ms == 0L) {
            return false;
        }
        Async async = this;
        synchronized (async) {
            if (this.isRealized) {
                return true;
            }
            this.isBlocked = true;
            try {
                if (ms < 0L) {
                    ((Object)((Object)this)).wait();
                } else {
                    ((Object)((Object)this)).wait(ms);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.isRealized;
        }
    }

    final void deliverAll(boolean success) {
        Receiver r;
        while ((r = this.receivers.poll()) != null) {
            this.deliver(r, success);
        }
    }

    final void deliver(Receiver r, boolean success) {
        try {
            if (success) {
                r.success(this.val);
            } else {
                r.error(this.err);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

