/*
 * Decompiled with CFR 0.152.
 */
package momentum.http;

import java.io.UnsupportedEncodingException;
import momentum.buffer.Buffer;
import momentum.http.WsFrameType;

public final class WsFrame {
    public static final int FIN_MASK = 128;
    public static final int LOWER_SEVEN = 127;
    WsFrameType type;
    boolean isMasked;
    boolean isFinal;
    int maskingKey;
    int statusCode;
    Buffer payload;

    public WsFrame() {
        this(null, false, true, null);
    }

    public WsFrame(WsFrameType type) {
        this(type, false, true, null);
    }

    public WsFrame(WsFrameType type, Buffer payload) {
        this(type, false, true, payload);
    }

    public WsFrame(WsFrameType type, boolean isFinal, Buffer payload) {
        this(type, false, isFinal, payload);
    }

    public WsFrame(WsFrameType type, boolean isMasked, boolean isFinal, Buffer payload) {
        this.type = type;
        this.isMasked = isMasked;
        this.isFinal = isFinal;
        this.payload = payload;
    }

    public WsFrameType type() {
        return this.type;
    }

    public WsFrameType type(WsFrameType val) {
        this.type = val;
        return val;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public int statusCode(int val) {
        this.statusCode = val;
        return val;
    }

    public boolean isMasked() {
        return this.isMasked;
    }

    public boolean isMasked(boolean val) {
        this.isMasked = val;
        return val;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isFinal(boolean val) {
        this.isFinal = val;
        return val;
    }

    public int maskingKey() {
        return this.maskingKey;
    }

    public int maskingKey(int val) {
        this.maskingKey = val;
        return val;
    }

    public Buffer payload() {
        return this.payload;
    }

    public Buffer payload(Buffer val) {
        this.payload = val;
        return val;
    }

    public String text() throws UnsupportedEncodingException {
        return this.payload.toString("UTF-8");
    }

    public boolean isContinuation() {
        return this.type == WsFrameType.CONTINUATION;
    }

    public boolean isText() {
        return this.type == WsFrameType.TEXT;
    }

    public boolean isBinary() {
        return this.type == WsFrameType.BINARY;
    }

    public boolean isClose() {
        return this.type == WsFrameType.CLOSE;
    }

    public boolean isPing() {
        return this.type == WsFrameType.PING;
    }

    public boolean isPong() {
        return this.type == WsFrameType.PONG;
    }

    public Buffer encode() throws UnsupportedEncodingException {
        int length = this.payload.remaining();
        Buffer buf = Buffer.allocate(16);
        buf.put((byte)(this.opCode() | 0x80));
        if (this.isClose()) {
            length += 2;
        }
        if (length <= 125) {
            buf.put((byte)length);
        } else if (length <= 65535) {
            buf.put((byte)126);
            buf.putShort((short)length);
        } else {
            buf.put((byte)127);
            buf.putLong(length);
        }
        if (this.isClose()) {
            buf.putShortUnsigned(this.statusCode);
        }
        buf.flip();
        return Buffer.wrap(buf, this.payload);
    }

    private int opCode() {
        switch (this.type) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSE: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        throw new RuntimeException("Unknown frame type");
    }
}

