/*
 * Decompiled with CFR 0.152.
 */
package momentum.buffer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import momentum.buffer.Buffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public final class ChannelBufferBackedBuffer
extends Buffer {
    final ChannelBuffer buf;

    protected ChannelBufferBackedBuffer(ChannelBuffer buf) {
        this(buf, buf.readerIndex(), buf.writerIndex(), buf.capacity(), true);
    }

    protected ChannelBufferBackedBuffer(ChannelBuffer buf, int pos, int lim, int cap) {
        this(buf, pos, lim, cap, true);
    }

    protected ChannelBufferBackedBuffer(ChannelBuffer buf, int pos, int lim, int cap, boolean be) {
        super(pos, lim, cap, be);
        this.buf = buf;
    }

    protected Buffer _slice(int idx, int len) {
        return new ChannelBufferBackedBuffer(this.buf.slice(idx, len), 0, len, len, this.bigEndian);
    }

    protected ByteBuffer _toByteBuffer() {
        ByteBuffer ret = this.buf.toByteBuffer();
        return ret.slice();
    }

    protected ChannelBuffer _toChannelBuffer() {
        if (this.order() == this.buf.order()) {
            return this.buf;
        }
        ByteBuffer bb = this._toByteBuffer();
        bb.order(this.order());
        return ChannelBuffers.wrappedBuffer((ByteBuffer)bb);
    }

    protected byte[] _toByteArray() {
        if (this.buf.hasArray()) {
            byte[] ret = this.buf.array();
            if (this.buf.arrayOffset() == 0 && ret.length == this.capacity) {
                return ret;
            }
            int offset = this.buf.arrayOffset();
            return Arrays.copyOfRange(ret, offset, offset + this.buf.capacity());
        }
        return super._toByteArray();
    }

    protected byte _get(int idx) {
        return this.buf.getByte(idx);
    }

    protected void _get(int idx, byte[] dst, int offset, int len) {
        this.buf.getBytes(idx, dst, offset, len);
    }

    protected void _put(int idx, byte b) {
        this.buf.setByte(idx, (int)b);
    }

    protected void _put(int idx, byte[] src, int offset, int len) {
        this.buf.setBytes(idx, src, offset, len);
    }
}

