/*
 * Decompiled with CFR 0.152.
 */
package momentum.async;

import clojure.lang.Counted;
import momentum.async.AsyncVal;

public final class AsyncTransferQueue
implements Counted {
    static final Node CLOSED = new Node(null, null);
    int count = 0;
    Node head;
    Node tail;
    final Object defaultVal;
    Exception err;

    public AsyncTransferQueue(Object defaultVal) {
        this.defaultVal = defaultVal;
    }

    public boolean put(Object o) {
        return this.transfer(o, null);
    }

    public boolean abort(Exception e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.doClose(e);
    }

    public boolean close() {
        return this.doClose(null);
    }

    public AsyncVal take() {
        AsyncVal request = new AsyncVal();
        if (!this.transfer(null, request)) {
            if (this.err == null) {
                request.put(this.defaultVal);
            } else {
                request.abort(this.err);
            }
        }
        return request;
    }

    public synchronized int count() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transfer(Object o, AsyncVal request) {
        Node matched;
        boolean haveData = request == null;
        AsyncTransferQueue asyncTransferQueue = this;
        synchronized (asyncTransferQueue) {
            if (this.tail == CLOSED && (haveData || this.head == null)) {
                return false;
            }
            matched = this.tryMatch(haveData);
            if (matched == null) {
                this.append(new Node(o, request));
            }
            this.updateCount(haveData);
        }
        if (matched != null) {
            matched.realize(o, request);
        }
        return true;
    }

    private Node tryMatch(boolean haveData) {
        if (this.head == null || haveData == this.head.isData()) {
            return null;
        }
        Node match = this.head;
        if (this.tail == match) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = match.next();
        }
        match.next(null);
        return match;
    }

    private void append(Node s) {
        if (this.tail != null) {
            this.tail.next(s);
            this.tail = s;
        } else {
            this.tail = this.head = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doClose(Exception e) {
        Node curr;
        AsyncTransferQueue asyncTransferQueue = this;
        synchronized (asyncTransferQueue) {
            if (this.tail == CLOSED) {
                return false;
            }
            this.err = e;
            this.tail = CLOSED;
        }
        while ((curr = this.head) != null && !this.head.isData()) {
            curr.realize(this.defaultVal, this.err);
            this.head = curr.next();
            curr.next(null);
        }
        return true;
    }

    private void updateCount(boolean haveData) {
        this.count = haveData ? ++this.count : --this.count;
    }

    static final class Node {
        Node next = null;
        final Object val;
        final AsyncVal request;

        Node(Object o, AsyncVal req) {
            this.val = o;
            this.request = req;
        }

        boolean isData() {
            return this.request == null;
        }

        Node next() {
            return this.next;
        }

        Node next(Node val) {
            this.next = val;
            return val;
        }

        void realize(Object o, AsyncVal req) {
            if (this.request == null) {
                req.put(this.val);
            } else {
                this.request.put(o);
            }
        }

        void realize(Object o, Exception err) {
            if (this.request != null) {
                if (err != null) {
                    this.request.abort(err);
                } else {
                    this.request.put(o);
                }
            }
        }
    }
}

