/*
 * Decompiled with CFR 0.152.
 */
package momentum.core;

import clojure.lang.AFn;
import clojure.lang.IBlockingDeref;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPending;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import momentum.core.Deferred;
import momentum.core.Receivable;
import momentum.core.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pipeline
extends AFn
implements Receivable,
IDeref,
IBlockingDeref,
IPending {
    static final Stage FINAL = new Stage(null, null, null);
    final Stage head;
    final Deferred result;
    final List<Catcher> catchers;
    final IFn finalizer;
    final AtomicReference<Stage> cs;

    public Pipeline(List<IFn> stages, List<Catcher> catchers, IFn finalizer) {
        Iterator<IFn> i = stages.iterator();
        Stage curr = null;
        while (i.hasNext()) {
            curr = new Stage(i.next(), curr, this);
        }
        this.head = curr;
        this.cs = new AtomicReference();
        this.result = new Deferred();
        this.catchers = catchers;
        this.finalizer = finalizer;
    }

    public boolean put(Object v) {
        if (!this.cs.compareAndSet(null, this.head)) {
            return false;
        }
        if (v instanceof Receivable) {
            Receivable r = (Receivable)v;
            r.receive(new FirstStage(this.head, this));
        } else {
            this.head.put(v);
        }
        return true;
    }

    public Object invoke(Object v) {
        return this.put(v);
    }

    public boolean abort(Exception e) {
        return this.error(e);
    }

    public boolean isRealized() {
        return this.result.isRealized();
    }

    public boolean isSuccessful() {
        return this.result.isSuccessful();
    }

    public boolean isAborted() {
        return this.result.isAborted();
    }

    @Override
    public void receive(Receiver r) {
        this.result.receive(r);
    }

    public Object deref() {
        return this.result.deref();
    }

    public Object deref(long ms, Object timeoutValue) {
        return this.result.deref(ms, timeoutValue);
    }

    void success(Object val) {
        Stage curr = this.cs.getAndSet(FINAL);
        if (curr == FINAL) {
            return;
        }
        try {
            if (this.finalizer != null) {
                this.finalizer.invoke();
            }
            this.result.put(val);
        }
        catch (Exception err) {
            this.result.abort(err);
        }
    }

    boolean error(Exception err) {
        Stage curr = this.cs.getAndSet(FINAL);
        if (curr == FINAL) {
            return false;
        }
        boolean caught = false;
        Object val = null;
        if (this.catchers != null) {
            try {
                for (Catcher c : this.catchers) {
                    if (!c.isMatch(err)) continue;
                    val = c.invoke(err);
                    caught = true;
                    break;
                }
            }
            catch (Exception e) {
                err = e;
            }
        }
        if (this.finalizer != null) {
            try {
                this.finalizer.invoke();
            }
            catch (Exception e) {
                caught = false;
                err = e;
            }
        }
        if (caught) {
            this.result.put(val);
        } else {
            this.result.abort(err);
        }
        return true;
    }

    static final class FirstStage
    implements Receiver {
        final Stage next;
        final Pipeline pipeline;

        FirstStage(Stage next, Pipeline pipeline) {
            this.next = next;
            this.pipeline = pipeline;
        }

        public void success(Object val) {
            if (this.pipeline.cs.get() == this.next) {
                this.next.put(val);
            }
        }

        public void error(Exception err) {
            this.pipeline.error(err);
        }
    }

    static final class Stage
    implements Receiver {
        final IFn fn;
        final Stage next;
        final Pipeline pipeline;
        boolean recur;

        Stage(IFn fn, Stage next, Pipeline pipeline) {
            this.fn = fn;
            this.next = next;
            this.pipeline = pipeline;
        }

        void put(Object val) {
            try {
                while (true) {
                    if ((val = this.fn.invoke(val)) instanceof Recur) {
                        this.recur = true;
                        val = ((Recur)val).val();
                    }
                    if (val instanceof Receivable) {
                        ((Receivable)val).receive(this);
                        return;
                    }
                    if (!this.recur) {
                        this.success(val);
                        return;
                    }
                    this.recur = false;
                }
            }
            catch (Exception e) {
                this.error(e);
                return;
            }
        }

        public void success(Object val) {
            if (this.recur) {
                if (this.pipeline.cs.get() == this) {
                    this.recur = false;
                    this.put(val);
                }
            } else if (this.next != null) {
                if (this.pipeline.cs.compareAndSet(this, this.next)) {
                    this.next.put(val);
                }
            } else {
                this.pipeline.success(val);
            }
        }

        public void error(Exception err) {
            this.pipeline.error(err);
        }
    }

    public static class Recur {
        final Object val;

        public Recur(Object val) {
            this.val = val;
        }

        public Object val() {
            return this.val;
        }
    }

    public static class Catcher {
        final Class klass;
        final IFn callback;

        public Catcher(Class klass, IFn callback) {
            this.klass = klass;
            this.callback = callback;
        }

        public boolean isMatch(Exception err) {
            return this.klass.isInstance(err);
        }

        public Object invoke(Exception err) throws Exception {
            return this.callback.invoke((Object)err);
        }
    }
}

