/*
 * Decompiled with CFR 0.152.
 */
package momentum.core;

import java.nio.ByteBuffer;
import java.util.Arrays;
import momentum.core.Buffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public final class HeapBuffer
extends Buffer {
    final int offset;
    final byte[] arr;

    protected HeapBuffer(byte[] arr, int off, int pos, int lim, int cap) {
        this(arr, off, pos, lim, cap, true);
    }

    protected HeapBuffer(byte[] arr, int off, int pos, int lim, int cap, boolean be) {
        super(pos, lim, cap, be);
        this.offset = off;
        this.arr = arr;
    }

    protected Buffer _slice(int idx, int len) {
        return new HeapBuffer(this.arr, this.offset + idx, 0, len, len, this.bigEndian);
    }

    protected ByteBuffer _toByteBuffer() {
        return ByteBuffer.wrap(this.arr, this.offset, this.capacity).slice();
    }

    protected ChannelBuffer _toChannelBuffer() {
        return ChannelBuffers.wrappedBuffer((byte[])this.arr, (int)this.offset, (int)this.capacity);
    }

    protected byte[] _toByteArray() {
        if (this.offset == 0 && this.capacity == this.arr.length) {
            return this.arr;
        }
        return Arrays.copyOfRange(this.arr, this.offset, this.offset + this.capacity);
    }

    public byte _get(int idx) {
        return this.arr[this.offset + idx];
    }

    protected void _get(int idx, byte[] dst, int off, int len) {
        System.arraycopy(this.arr, this.offset + idx, dst, off, len);
    }

    protected void _put(int idx, byte b) {
        this.arr[this.offset + idx] = b;
    }

    protected void _put(int idx, byte[] src, int off, int len) {
        System.arraycopy(src, off, this.arr, this.offset + idx, len);
    }

    protected void _put(int idx, Buffer src, int off, int len) {
        if (src instanceof HeapBuffer) {
            HeapBuffer s = (HeapBuffer)src;
            System.arraycopy(s.arr, s.offset + off, this.arr, this.offset + idx, len);
        } else {
            src._get(off, this.arr, this.offset + idx, len);
        }
    }
}

