/*
 * Decompiled with CFR 0.152.
 */
package momentum.core;

import clojure.lang.ASeq;
import clojure.lang.IPending;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import java.util.LinkedList;
import momentum.core.Channel;
import momentum.core.Deferred;
import momentum.core.Receivable;
import momentum.core.Receiver;
import momentum.core.TimeoutException;

public final class DeferredSeq
extends ASeq
implements Receivable,
IPending {
    final Channel chan;
    volatile boolean isRealized;
    boolean isBlocked;
    Object head;
    Exception err;
    final LinkedList<Receiver> receivers;
    final Deferred read;
    DeferredSeq next;

    DeferredSeq(Channel ch) {
        this.chan = ch;
        this.read = new Deferred();
        this.receivers = new LinkedList();
    }

    public boolean isRealized() {
        return this.isRealized;
    }

    public boolean isSuccessful() {
        return this.isRealized && this.err == null;
    }

    public boolean isAborted() {
        return this.isRealized && this.err != null;
    }

    DeferredSeq grow() {
        this.next = new DeferredSeq(this.chan);
        return this.next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Receivable put(Object v) {
        Receiver r;
        DeferredSeq deferredSeq = this;
        synchronized (deferredSeq) {
            if (this.isRealized) {
                throw new IllegalStateException("Deferred seq head previously realized");
            }
            this.head = v;
            this.isRealized = true;
            if (this.isBlocked) {
                this.notifyAll();
            }
        }
        while ((r = this.receivers.poll()) != null) {
            this.deliver(r);
        }
        return this.read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Exception e) {
        Receiver r;
        DeferredSeq deferredSeq = this;
        synchronized (deferredSeq) {
            if (this.isRealized) {
                throw new IllegalStateException("Deferred seq head previously realized");
            }
            this.err = e;
            this.isRealized = true;
            if (this.isBlocked) {
                this.notifyAll();
            }
        }
        while ((r = this.receivers.poll()) != null) {
            this.deliver(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Receiver r) {
        if (r == null) {
            throw new NullPointerException("Receiver is null");
        }
        if (this.isRealized) {
            this.deliver(r);
            return;
        }
        DeferredSeq deferredSeq = this;
        synchronized (deferredSeq) {
            if (!this.isRealized) {
                this.receivers.add(r);
                return;
            }
        }
        this.deliver(r);
    }

    public Object first() {
        if (this.read.isRealized()) {
            return this.head;
        }
        if (this.isRealized) {
            if (this.err != null) {
                throw new RuntimeException(this.err);
            }
            this.observe();
            return this.head;
        }
        if (this.chan.canBlock) {
            this.block();
            return this.first();
        }
        throw new IllegalStateException("Deferred seq head not realized");
    }

    public ISeq next() {
        if (this.read.isRealized()) {
            return this.next;
        }
        if (this.isRealized) {
            if (this.err != null) {
                throw new RuntimeException(this.err);
            }
            this.observe();
            return this.next;
        }
        if (this.chan.canBlock) {
            this.block();
            return this.next();
        }
        throw new IllegalStateException("Deferred seq head not realized");
    }

    public Obj withMeta(IPersistentMap meta) {
        throw new RuntimeException("Not supported yet");
    }

    private synchronized void observe() {
        if (!this.read.isRealized()) {
            this.read.put(this);
            this.chan.head = this.next;
        }
    }

    private void deliver(Receiver r) {
        try {
            if (this.err != null) {
                r.error(this.err);
            } else {
                r.success(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block() {
        DeferredSeq deferredSeq = this;
        synchronized (deferredSeq) {
            if (!this.isRealized) {
                if (this.chan.timeout == 0L) {
                    throw new TimeoutException();
                }
                this.isBlocked = true;
                try {
                    if (this.chan.timeout < 0L) {
                        this.wait();
                    } else {
                        this.wait(this.chan.timeout);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (!this.isRealized) {
                    throw new TimeoutException();
                }
            }
        }
    }
}

