/*
 * Decompiled with CFR 0.152.
 */
package starkiller.alpha;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;

public interface Discovery {
    public CompletableFuture<DiscoveryResult> discover();

    public static final class DiscoveryResult {
        public final Set<Node> nodes;
        public final Set<Node> addedNodes;
        public final Set<Node> removedNodes;

        public DiscoveryResult(Set<Node> nodes, Set<Node> addedNodes, Set<Node> removedNodes) {
            this.nodes = nodes;
            this.addedNodes = addedNodes;
            this.removedNodes = removedNodes;
        }

        public String toString() {
            return "DiscoveryResult{nodes=" + this.nodes + ", addedNodes=" + this.addedNodes + ", removedNodes=" + this.removedNodes + "}";
        }
    }

    public static final class Node
    implements Comparable<Node> {
        public final String id;
        public final InetSocketAddress address;
        public final SortedSet<Long> tokens;

        public Node(String id, InetSocketAddress address) {
            this(id, address, Collections.emptySortedSet());
        }

        public Node(String id, InetSocketAddress address, SortedSet<Long> tokens) {
            this.id = id;
            this.address = address;
            this.tokens = Collections.unmodifiableSortedSet(tokens);
        }

        public Node withTokens(SortedSet<Long> tokens) {
            return new Node(this.id, this.address, tokens);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.id, node.id) && Objects.equals(this.address, node.address) && Objects.equals(this.tokens, node.tokens);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.address, this.tokens);
        }

        public String toString() {
            return "Node{id='" + this.id + "', address=" + this.address + ", tokens=" + this.tokens + "}";
        }

        @Override
        public int compareTo(Node o) {
            int cmp = this.address.getAddress().getHostAddress().compareTo(o.address.getAddress().getHostAddress());
            if (cmp == 0) {
                return Integer.compare(this.address.getPort(), o.address.getPort());
            }
            return cmp;
        }
    }
}

