/*
 * Decompiled with CFR 0.152.
 */
package starkiller.alpha;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import starkiller.alpha.Discovery;

public class ConsulDiscovery
implements Discovery {
    private final HttpClient httpClient;
    private final URI consulUri;
    private final String serviceName;
    private final AtomicReference<String> token = new AtomicReference<Object>(null);
    private final AtomicReference<SortedSet<Discovery.Node>> nodes = new AtomicReference(Collections.emptySortedSet());
    private final ObjectMapper objectMapper = new ObjectMapper();
    public static final URI DEFAULT_URI;
    public static final String DEFAULT_SERVICE_NAME = "skywalker";

    public ConsulDiscovery() {
        this(DEFAULT_URI);
    }

    public ConsulDiscovery(URI consulUri) {
        this(consulUri, DEFAULT_SERVICE_NAME);
    }

    public ConsulDiscovery(URI consulUri, String serviceName) {
        this.httpClient = HttpClient.newHttpClient();
        this.consulUri = consulUri;
        this.serviceName = serviceName;
    }

    @Override
    public CompletableFuture<Discovery.DiscoveryResult> discover() {
        String path = "/v1/health/service/" + this.serviceName + "?wat=60s&passing=true";
        String index = this.token.get();
        if (index != null) {
            path = path + "&index=" + index;
        }
        URI uri = this.consulUri.resolve(path);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
        CompletableFuture<HttpResponse<byte[]>> requestFuture = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray());
        return requestFuture.thenApply(response -> {
            if (response.statusCode() == 200) {
                try {
                    JsonParser parser = this.objectMapper.createParser((byte[])response.body());
                    if (parser.nextToken() == JsonToken.START_ARRAY) {
                        LinkedList<ConsulHealthEntry> entries = new LinkedList<ConsulHealthEntry>();
                        while (parser.nextToken() != JsonToken.END_ARRAY) {
                            entries.add((ConsulHealthEntry)parser.readValueAs(ConsulHealthEntry.class));
                        }
                        SortedSet<Discovery.Node> currentNodes = this.nodes.get();
                        SortedSet nextNodes = currentNodes.stream().filter(n -> {
                            for (ConsulHealthEntry e : entries) {
                                if (!n.id.equals(e.node.id)) continue;
                                return true;
                            }
                            return false;
                        }).collect(Collectors.toCollection(TreeSet::new));
                        SortedSet addedNodes = entries.stream().filter(e -> {
                            for (Discovery.Node n : nextNodes) {
                                if (!n.id.equals(e.node.id)) continue;
                                return false;
                            }
                            return true;
                        }).map(e -> new Discovery.Node(e.node.id, new InetSocketAddress(e.node.address, (int)e.service.port))).collect(Collectors.toCollection(TreeSet::new));
                        nextNodes.addAll(addedNodes);
                        TreeSet<Discovery.Node> removedNodes = new TreeSet<Discovery.Node>(currentNodes);
                        removedNodes.removeAll(nextNodes);
                        this.nodes.compareAndSet(currentNodes, nextNodes);
                        response.headers().firstValue("X-Consul-Index").stream().forEach(this.token::set);
                        return new Discovery.DiscoveryResult(nextNodes, addedNodes, removedNodes);
                    }
                    throw new RuntimeException("expected JSON array response");
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            throw new RuntimeException(String.format("consul failed with status %d", response.statusCode()));
        });
    }

    static {
        try {
            DEFAULT_URI = new URI("http://localhost:8500");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConsulHealthEntry {
        @JsonProperty(value="Node")
        public Node node;
        @JsonProperty(value="Service")
        public Service service;
        @JsonProperty(value="Checks")
        public List<Check> checks;

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Check {
            @JsonProperty(value="Node")
            public String node;
            @JsonProperty(value="CheckID")
            public String checkId;
            @JsonProperty(value="Name")
            public String name;
            @JsonProperty(value="Status")
            public String status;
            @JsonProperty(value="CreateIndex")
            public Integer createIndex;
            @JsonProperty(value="ModifyIndex")
            public Integer modifyIndex;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Service {
            @JsonProperty(value="ID")
            public String id;
            @JsonProperty(value="Service")
            public String service;
            @JsonProperty(value="Tags")
            public List<String> tags;
            @JsonProperty(value="Address")
            public String address;
            @JsonProperty(value="Port")
            public Integer port;
            @JsonProperty(value="CreateIndex")
            public Integer createIndex;
            @JsonProperty(value="ModifyIndex")
            public Integer modifyIndex;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Node {
            @JsonProperty(value="ID")
            public String id;
            @JsonProperty(value="Node")
            public String node;
            @JsonProperty(value="Address")
            public String address;
            @JsonProperty(value="Datacenter")
            public String datacenter;
            @JsonProperty(value="CreateIndex")
            public Integer createIndex;
            @JsonProperty(value="ModifyIndex")
            public Integer modifyIndex;
        }
    }
}

