/*
 * Decompiled with CFR 0.152.
 */
package starkiller.alpha;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import starkiller.Junction;
import starkiller.RemoteJunction;
import starkiller.alpha.Discovery;

public class ClusterJunction<K, V>
implements Junction<K, V> {
    private final Discovery discovery;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicReference<List<ClusterEntry>> entries = new AtomicReference(Collections.emptyList());
    private final AtomicReference<CompletableFuture<Object>> changedFuture = new AtomicReference(new CompletableFuture());

    public ClusterJunction(Discovery discovery) {
        this.discovery = discovery;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.runLoop();
        }
    }

    private void runLoop() {
        this.discovery.discover().whenComplete((discoveryResult, throwable) -> {
            if (discoveryResult != null) {
                List entries = this.entries.get();
                entries = entries.stream().filter(e -> discoveryResult.removedNodes.stream().noneMatch(n -> e.id.equals(n.id))).collect(Collectors.toCollection(ArrayList::new));
                CompletableFuture.allOf((CompletableFuture[])discoveryResult.addedNodes.stream().map(n -> {
                    final CompletableFuture future = new CompletableFuture();
                    try {
                        AsynchronousSocketChannel socket = AsynchronousSocketChannel.open();
                        socket.connect(n.address, null, new CompletionHandler<Void, Object>(){

                            @Override
                            public void completed(Void result, Object attachment) {
                                RemoteJunction junct = new RemoteJunction(null, null, n -> {});
                                junct.tokens().whenComplete((tokens, ex) -> {
                                    if (ex != null) {
                                        future.completeExceptionally((Throwable)ex);
                                    } else {
                                        future.complete(tokens.stream().map(t -> new ClusterEntry((long)t, junct, n2.id)).collect(Collectors.toList()));
                                    }
                                });
                            }

                            @Override
                            public void failed(Throwable exc, Object attachment) {
                                future.completeExceptionally(exc);
                            }
                        });
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                    return future;
                }).toArray(CompletableFuture[]::new));
            }
            if (this.running.get()) {
                this.runLoop();
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> send(K id, V value, long timeout, TimeUnit timeoutUnit) {
        return null;
    }

    @Override
    public CompletableFuture<V> recv(K id, long timout, TimeUnit timeoutUnit) {
        return null;
    }

    class ClusterEntry
    implements Comparable<ClusterEntry> {
        public final long token;
        public final RemoteJunction<K, V> junction;
        public final String id;

        ClusterEntry(long token, RemoteJunction<K, V> junction, String id) {
            this.token = token;
            this.junction = junction;
            this.id = id;
        }

        @Override
        public int compareTo(ClusterEntry o) {
            return Long.compare(this.token, o.token);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterEntry that = (ClusterEntry)o;
            return this.token == that.token && Objects.equals(this.junction, that.junction) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.token, this.junction, this.id);
        }
    }
}

