/*
 * Decompiled with CFR 0.152.
 */
package starkiller;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import starkiller.Util;

public class Timer {
    private static final long TIMEOUT_RESOLUTION_MS = 10L;
    private static final DelayQueue<TimeoutEntry> timeoutQueue = new DelayQueue();
    private static final ConcurrentSkipListMap<Long, TimeoutEntry> entryMap = new ConcurrentSkipListMap();
    private static Thread timeoutWorker = null;

    private static synchronized Thread ensureWorker() {
        if (timeoutWorker == null) {
            timeoutWorker = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            TimeoutEntry e = (TimeoutEntry)timeoutQueue.take();
                            entryMap.remove(e.timestamp);
                            e.future.complete(null);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Util.logger.warn("interrupted in timeout worker", (Throwable)interruptedException);
                        continue;
                    }
                    break;
                }
            });
            timeoutWorker.setDaemon(true);
            timeoutWorker.setName("starkiller-timeout-worker");
            timeoutWorker.start();
        }
        return timeoutWorker;
    }

    static CompletableFuture<Void> timeout(long duration, TimeUnit unit) {
        Timer.ensureWorker();
        long now = System.currentTimeMillis();
        long timestamp = (now + TimeUnit.MILLISECONDS.convert(duration, unit)) / 10L * 10L;
        Util.logger.trace("timeout:{}, unit:{}, timestamp:{}, now:{}", new Object[]{duration, unit, timestamp, now});
        Map.Entry<Long, TimeoutEntry> e = entryMap.ceilingEntry(timestamp);
        if (e != null && e.getKey() < timestamp + 10L) {
            return e.getValue().future;
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TimeoutEntry entry = new TimeoutEntry(timestamp, future);
        entryMap.put(timestamp, entry);
        timeoutQueue.put(entry);
        return future;
    }

    private static class TimeoutEntry
    implements Delayed {
        private final long timestamp;
        final CompletableFuture<Void> future;

        public TimeoutEntry(long timestamp, CompletableFuture<Void> future) {
            this.timestamp = timestamp;
            this.future = future;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.timestamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.timestamp, ((TimeoutEntry)o).timestamp);
        }
    }
}

