/*
 * Decompiled with CFR 0.152.
 */
package starkiller;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import starkiller.RemoteJunction;

class MsgPack<K, V> {
    private final Class<? extends V> valueClass;
    private final ObjectMapper objectMapper;
    private static final Logger logger = LoggerFactory.getLogger(MsgPack.class);

    MsgPack(ObjectMapper objectMapper, Class<? extends V> valueClass) {
        this.objectMapper = objectMapper;
        this.valueClass = valueClass;
    }

    private String unpackString(ByteBuffer buffer) throws IOException {
        int bytesLength;
        int b = buffer.get() & 0xFF;
        if (b >= 160 && b <= 191) {
            bytesLength = b & 0x1F;
        } else if (b == 217) {
            bytesLength = buffer.get() & 0xFF;
        } else if (b == 218) {
            bytesLength = buffer.getShort() & 0xFFFF;
        } else if (b == 219) {
            bytesLength = buffer.getInt();
        } else {
            throw new IOException(String.format("invalid byte %02x in stream", b));
        }
        byte[] bytes = new byte[bytesLength];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private long unpackLong(ByteBuffer buffer) throws IOException {
        int b = buffer.get() & 0xFF;
        if (b <= 127) {
            return b;
        }
        if (b >= 224) {
            return (long)b | 0xFFFFFFFFFFFFFF00L;
        }
        if (b == 204) {
            return buffer.get() & 0xFF;
        }
        if (b == 205) {
            return buffer.getShort() & 0xFFFF;
        }
        if (b == 206) {
            return (long)buffer.getInt() & 0xFFFFFFFFL;
        }
        if (b == 207 || b == 211) {
            return buffer.getLong();
        }
        if (b == 208) {
            return buffer.get();
        }
        if (b == 209) {
            return buffer.getShort();
        }
        if (b == 210) {
            return buffer.getInt();
        }
        throw new IOException(String.format("invalid byte %02x in stream", b));
    }

    private boolean peekTimeout(ByteBuffer buffer) {
        int b = (buffer = buffer.asReadOnlyBuffer().slice()).get() & 0xFF;
        if (b == 212) {
            b = buffer.get() & 0xFF;
            return b == 84;
        }
        return false;
    }

    private int unpackArrayStart(ByteBuffer buffer) throws IOException {
        int arrayLength;
        int b = buffer.get() & 0xFF;
        if (b >= 72 && b <= 159) {
            arrayLength = b & 0xF;
        } else if (b == 220) {
            arrayLength = buffer.getShort() & 0xFFFF;
        } else if (b == 221) {
            arrayLength = buffer.getInt();
        } else {
            throw new IOException(String.format("invalid byte %02x in stream", b));
        }
        return arrayLength;
    }

    RemoteJunction.Response<V> unpackResponse(ByteBuffer buffer) throws IOException {
        int arrayLength = this.unpackArrayStart(buffer);
        if (arrayLength != 3) {
            throw new IOException(String.format("invalid response array length: %d", arrayLength));
        }
        String method = this.unpackString(buffer);
        long messageId = this.unpackLong(buffer);
        boolean isTimeout = this.peekTimeout(buffer);
        switch (method) {
            case ":recv!": {
                if (isTimeout) {
                    buffer.position(buffer.position() + 3);
                    return new RemoteJunction.TimeoutResponse(messageId);
                }
                Object value = this.objectMapper.readValue((InputStream)new ByteBufferBackedInputStream(buffer), this.valueClass);
                return new RemoteJunction.RecvResponse<Object>(messageId, value);
            }
            case ":send!": {
                if (isTimeout) {
                    buffer.position(buffer.position() + 3);
                    return new RemoteJunction.TimeoutResponse(messageId);
                }
                Boolean value = (Boolean)this.objectMapper.readValue((InputStream)new ByteBufferBackedInputStream(buffer), Boolean.class);
                return new RemoteJunction.SendResponse(messageId, value);
            }
            case ":tokens": {
                int tokenCount = this.unpackArrayStart(buffer);
                ArrayList<Long> tokens = new ArrayList<Long>(tokenCount);
                for (int i = 0; i < tokenCount; ++i) {
                    tokens.add(this.unpackLong(buffer));
                }
                return new RemoteJunction.TokenResponse(messageId, tokens);
            }
        }
        throw new IOException(String.format("invalid method name %s", method));
    }

    byte[] packRequest(RemoteJunction.Request<K, V> request) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (request instanceof RemoteJunction.SendRequest) {
            RemoteJunction.SendRequest sr = (RemoteJunction.SendRequest)request;
            JsonGenerator gen = this.objectMapper.createGenerator((OutputStream)bout);
            gen.writeStartArray(5);
            gen.writeString(":send!");
            gen.writeNumber(request.messageId);
            gen.writeNumber(sr.timeout.longValue());
            gen.writeObject(sr.id);
            gen.writeObject(sr.value);
            gen.writeEndArray();
            gen.flush();
            gen.close();
        } else if (request instanceof RemoteJunction.RecvRequest) {
            RemoteJunction.RecvRequest rr = (RemoteJunction.RecvRequest)request;
            JsonGenerator gen = this.objectMapper.createGenerator((OutputStream)bout);
            gen.writeStartArray(4);
            gen.writeString(":recv!");
            gen.writeNumber(rr.messageId);
            gen.writeNumber(rr.timeout.longValue());
            gen.writeObject(rr.id);
            gen.writeEndArray();
            gen.flush();
            gen.close();
        } else if (request instanceof RemoteJunction.TokenRequest) {
            JsonGenerator gen = this.objectMapper.createGenerator((OutputStream)bout);
            gen.writeStartArray(2);
            gen.writeString(":tokens");
            gen.writeNumber(request.messageId);
            gen.writeEndArray();
            gen.flush();
            gen.close();
        } else {
            throw new IllegalArgumentException("unsupported class " + (request != null ? request.getClass().getName() : "null"));
        }
        return bout.toByteArray();
    }
}

