create table schemamap.data_migration_states (
  value text primary key,
  comment text
);

insert into schemamap.data_migration_states
(value, comment)
values
('LOADING', 'The data is being loaded into the staging tables.'),
('LOADED', 'The data has been loaded into the staging tables without issues.'),
('LOAD_FAILED', 'The data load has failed in an irrecoverable manner.'),
('IMPORTING', 'The data is being migrated from the staging table to the target tables.'),
('IMPORTED', 'The data has been migrated without catastrophic failures.'),
('IMPORT_FAILED', 'The data migration has failed in an irrecoverable manner.');

create table schemamap.data_migration_sources (
  value text primary key,
  comment text
);

insert into schemamap.data_migration_sources
(value, comment)
values
('POSTGRES', 'Postgres->Postgres sync'),
('GOOGLE_SPREADSHEET', 'Google Spreadsheet import'),
('XLSX', 'Excel file import'),
('CSV', 'CSV file import'),
('SALESFORCE', 'Salesforce API import');

create table schemamap.data_migrations (
  id bigint primary key generated by default as identity,
  state text not null references data_migration_states,
  source text not null references data_migration_sources,
  mde_name text not null,

  tenant_name text,
  tenant_id text,

  comment text,

  requester_user_id text,
  requester_email text,

  import_started_at timestamptz,
  imported_at timestamptz,

  summary jsonb,

  created_at timestamptz not null default now(),
  updated_at timestamptz not null default now(),
  version bigint not null default 0 check (version >= 0)
);

comment on table schemamap.data_migrations is
  'Bookeeping table of data migrations/imports that happened to this database.';

select schemamap.add_common_triggers('schemamap.data_migrations');
