/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.vertx;

import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.resource.RevolverRequestResource;
import io.dropwizard.revolver.vertx.RequestUtil;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterRegistry {
    private static final Logger log = LoggerFactory.getLogger(RouterRegistry.class);
    private final Router router;
    private final RevolverRequestResource revolverRequestResource;

    public RouterRegistry(Router router, RevolverRequestResource revolverRequestResource) {
        this.router = router;
        this.revolverRequestResource = revolverRequestResource;
    }

    public void register() {
        this.router.route().path("/apis/*").method(HttpMethod.GET).handler(this::getResource);
        this.router.route().path("/apis/*").method(HttpMethod.POST).handler(this::getResource);
    }

    private void getResource(RoutingContext routingContext) {
        log.info("Executing via vertx for path : {}", (Object)routingContext.normalisedPath());
        UriInfo uriInfo = RequestUtil.getUriInfo(routingContext);
        HttpHeaders headers = RequestUtil.getHeaders(routingContext);
        String service = RequestUtil.getServiceName(routingContext);
        String path = RequestUtil.getApiPath(routingContext);
        byte[] body = RequestUtil.getBody(routingContext);
        log.info("Service : {}, Path : {}", (Object)service, (Object)path);
        try {
            this.revolverRequestResource.processRequest(routingContext, service, RevolverHttpApiConfig.RequestMethod.GET, path, headers, uriInfo, body);
        }
        catch (Exception e) {
            log.error("Error occurred while executing resource ", (Throwable)e);
        }
        log.info("Execution completed : " + routingContext.getBody());
    }

    public static RouterRegistryBuilder builder() {
        return new RouterRegistryBuilder();
    }

    public Router getRouter() {
        return this.router;
    }

    public RevolverRequestResource getRevolverRequestResource() {
        return this.revolverRequestResource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouterRegistry)) {
            return false;
        }
        RouterRegistry other = (RouterRegistry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Router this$router = this.getRouter();
        Router other$router = other.getRouter();
        if (this$router == null ? other$router != null : !this$router.equals(other$router)) {
            return false;
        }
        RevolverRequestResource this$revolverRequestResource = this.getRevolverRequestResource();
        RevolverRequestResource other$revolverRequestResource = other.getRevolverRequestResource();
        return !(this$revolverRequestResource == null ? other$revolverRequestResource != null : !this$revolverRequestResource.equals(other$revolverRequestResource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RouterRegistry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Router $router = this.getRouter();
        result = result * 59 + ($router == null ? 43 : $router.hashCode());
        RevolverRequestResource $revolverRequestResource = this.getRevolverRequestResource();
        result = result * 59 + ($revolverRequestResource == null ? 43 : $revolverRequestResource.hashCode());
        return result;
    }

    public String toString() {
        return "RouterRegistry(router=" + this.getRouter() + ", revolverRequestResource=" + this.getRevolverRequestResource() + ")";
    }

    public static class RouterRegistryBuilder {
        private Router router;
        private RevolverRequestResource revolverRequestResource;

        RouterRegistryBuilder() {
        }

        public RouterRegistryBuilder router(Router router) {
            this.router = router;
            return this;
        }

        public RouterRegistryBuilder revolverRequestResource(RevolverRequestResource revolverRequestResource) {
            this.revolverRequestResource = revolverRequestResource;
            return this;
        }

        public RouterRegistry build() {
            return new RouterRegistry(this.router, this.revolverRequestResource);
        }

        public String toString() {
            return "RouterRegistry.RouterRegistryBuilder(router=" + this.router + ", revolverRequestResource=" + this.revolverRequestResource + ")";
        }
    }
}

