/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.callback;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Strings;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.callback.CallbackHandler;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.core.config.RevolverConfigHolder;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.discovery.model.SimpleEndpointSpec;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.util.HeaderUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineCallbackHandler
extends CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(InlineCallbackHandler.class);
    private LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> clientLoadingCache = Caffeine.newBuilder().build(key -> this.buildConfiguration(((CallbackConfigKey)key).callbackRequest, ((CallbackConfigKey)key).endpoint));

    public InlineCallbackHandler(PersistenceProvider persistenceProvider, RevolverConfigHolder revolverConfigHolder) {
        super(persistenceProvider, revolverConfigHolder);
    }

    @Override
    public void handle(String requestId, RevolverCallbackResponse response) {
        RevolverCallbackRequest request = this.persistenceProvider.request(requestId);
        if (request == null) {
            log.warn("Invalid request: {}", (Object)requestId);
            return;
        }
        RevolverRequestState state = this.persistenceProvider.requestState(requestId);
        if (state == null) {
            log.warn("Invalid request state: {}", (Object)requestId);
            return;
        }
        if (Strings.isNullOrEmpty((String)request.getCallbackUri())) {
            log.warn("Invalid callback uri: {}", (Object)requestId);
            return;
        }
        try {
            URI uri = new URI(request.getCallbackUri());
            switch (uri.getScheme()) {
                case "https": 
                case "http": 
                case "ranger": {
                    this.makeCallback(requestId, uri, request, response);
                    break;
                }
                default: {
                    log.warn("Invalid protocol for request: {}", (Object)requestId);
                }
            }
            int mailboxTtl = HeaderUtil.getTTL((RevolverCallbackRequest)request);
            this.persistenceProvider.saveResponse(requestId, response, mailboxTtl);
        }
        catch (Exception e) {
            log.error("Invalid callback uri {} for request: {}", new Object[]{request.getCallbackUri(), requestId, e});
        }
    }

    private void makeCallback(String requestId, URI uri, RevolverCallbackRequest callbackRequest, RevolverCallbackResponse callBackResponse) {
        long start = System.currentTimeMillis();
        try {
            String callbackUri = uri.getScheme() + "://" + uri.getHost() + ":" + (uri.getPort() != -1 ? Integer.valueOf(uri.getPort()) : "");
            log.info("Callback Request URI: {} | Payload: {}", (Object)uri.toString(), (Object)new String(callBackResponse.getBody()));
            RevolverHttpServiceConfig httpCommandConfig = (RevolverHttpServiceConfig)this.clientLoadingCache.get((Object)CallbackConfigKey.builder().callbackRequest(callbackRequest).endpoint(callbackUri).build());
            if (null == httpCommandConfig) {
                log.error("Invalid callback configuration for key: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return;
            }
            RevolverHttpCommand httpCommand = this.getCommand(httpCommandConfig);
            MultivaluedHashMap requestHeaders = new MultivaluedHashMap();
            callBackResponse.getHeaders().forEach((arg_0, arg_1) -> ((MultivaluedMap)requestHeaders).put(arg_0, arg_1));
            requestHeaders.remove((Object)"Host");
            requestHeaders.putSingle((Object)"X-RESPONSE-CODE", (Object)String.valueOf(callBackResponse.getStatusCode()));
            String method = callbackRequest.getHeaders().getOrDefault("X-CALLBACK-METHOD", Collections.singletonList("POST")).get(0);
            method = Strings.isNullOrEmpty((String)method) ? "POST" : method;
            RevolverHttpRequest httpRequest = RevolverHttpRequest.builder().path(uri.getRawPath()).api("callback").body(callBackResponse.getBody() == null ? new byte[]{} : callBackResponse.getBody()).headers((MultivaluedMap)requestHeaders).method(RevolverHttpApiConfig.RequestMethod.valueOf((String)method)).service(httpCommandConfig.getService()).build();
            httpCommand.executeAsyncAsObservable((RevolverRequest)httpRequest).subscribe(response -> {
                if (response.getStatusCode() >= 200 && response.getStatusCode() <= 210) {
                    log.info("Callback success: " + response.toString());
                } else {
                    log.error("Error from callback for request id: {} | host: {} | Status Code: {} | Response Body: {}", new Object[]{requestId, uri.getHost(), response.getStatusCode(), response.getBody() != null ? new String(response.getBody()) : "NONE"});
                }
            }, error -> log.error("Error from callback for request id: {} | Error: {}", (Object)requestId, error));
            log.info("Callback complete for request id: {} in {} ms", (Object)requestId, (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            log.error("Error making callback for: {} for request: {}", new Object[]{uri.toString(), requestId, e});
        }
    }

    private RevolverHttpServiceConfig buildConfiguration(RevolverCallbackRequest callbackRequest, String endpoint) throws MalformedURLException, URISyntaxException {
        SimpleEndpointSpec endpointSpec = null;
        String apiName = "callback";
        URI uri = new URI(endpoint);
        String serviceName = uri.getHost().replace(".", "-");
        String type = null;
        String method = callbackRequest.getHeaders().getOrDefault("X-CALLBACK-METHOD", Collections.singletonList("POST")).get(0);
        method = Strings.isNullOrEmpty((String)method) ? "POST" : method;
        String timeout = callbackRequest.getHeaders().getOrDefault("X-CALLBACK-TIMEOUT", Collections.singletonList(String.valueOf(this.revolverConfigHolder.getConfig().getCallbackTimeout()))).get(0);
        timeout = Strings.isNullOrEmpty((String)timeout) ? String.valueOf(this.revolverConfigHolder.getConfig().getCallbackTimeout()) : timeout;
        switch (uri.getScheme()) {
            case "https": 
            case "http": {
                SimpleEndpointSpec simpleEndpoint = new SimpleEndpointSpec();
                simpleEndpoint.setHost(uri.getHost());
                simpleEndpoint.setPort(uri.getPort() == 0 || uri.getPort() == -1 ? 80 : uri.getPort());
                endpointSpec = simpleEndpoint;
                type = uri.getScheme();
                break;
            }
            case "ranger": {
                RangerEndpointSpec rangerEndpoint = new RangerEndpointSpec();
                String[] discoveryData = uri.getHost().split("\\.");
                if (discoveryData.length != 3) {
                    throw new MalformedURLException("Invalid ranger host format. Accepted format is environment.service.api");
                }
                rangerEndpoint.setEnvironment(discoveryData[0]);
                rangerEndpoint.setService(discoveryData[1]);
                endpointSpec = rangerEndpoint;
                type = "ranger_sharded";
                apiName = discoveryData[2];
            }
        }
        RevolverHttpServiceConfig httpConfig = RevolverHttpServiceConfig.builder().authEnabled(false).connectionPoolSize(10).secured(uri.getScheme().equals("https")).endpoint(endpointSpec).service(serviceName).type(type).api(RevolverHttpApiConfig.configBuilder().api(apiName).method(RevolverHttpApiConfig.RequestMethod.valueOf((String)method)).path(null).runtime(HystrixCommandConfig.builder().threadPool(ThreadPoolConfig.builder().concurrency(10).timeout(Integer.parseInt(timeout)).build()).build()).build()).build();
        RevolverBundle.addHttpCommand(httpConfig);
        return httpConfig;
    }

    private RevolverHttpCommand getCommand(RevolverHttpServiceConfig httpConfig) {
        return RevolverBundle.getHttpCommand(httpConfig.getService(), ((RevolverHttpApiConfig)httpConfig.getApis().iterator().next()).getApi());
    }

    public static InlineCallbackHandlerBuilder builder() {
        return new InlineCallbackHandlerBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineCallbackHandler)) {
            return false;
        }
        InlineCallbackHandler other = (InlineCallbackHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> this$clientLoadingCache = this.clientLoadingCache;
        LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> other$clientLoadingCache = other.clientLoadingCache;
        return !(this$clientLoadingCache == null ? other$clientLoadingCache != null : !this$clientLoadingCache.equals(other$clientLoadingCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineCallbackHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> $clientLoadingCache = this.clientLoadingCache;
        result = result * 59 + ($clientLoadingCache == null ? 43 : $clientLoadingCache.hashCode());
        return result;
    }

    public static class InlineCallbackHandlerBuilder {
        private PersistenceProvider persistenceProvider;
        private RevolverConfigHolder revolverConfigHolder;

        InlineCallbackHandlerBuilder() {
        }

        public InlineCallbackHandlerBuilder persistenceProvider(PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public InlineCallbackHandlerBuilder revolverConfigHolder(RevolverConfigHolder revolverConfigHolder) {
            this.revolverConfigHolder = revolverConfigHolder;
            return this;
        }

        public InlineCallbackHandler build() {
            return new InlineCallbackHandler(this.persistenceProvider, this.revolverConfigHolder);
        }

        public String toString() {
            return "InlineCallbackHandler.InlineCallbackHandlerBuilder(persistenceProvider=" + this.persistenceProvider + ", revolverConfigHolder=" + this.revolverConfigHolder + ")";
        }
    }

    private static class CallbackConfigKey {
        private String endpoint;
        private RevolverCallbackRequest callbackRequest;

        public static CallbackConfigKeyBuilder builder() {
            return new CallbackConfigKeyBuilder();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public RevolverCallbackRequest getCallbackRequest() {
            return this.callbackRequest;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setCallbackRequest(RevolverCallbackRequest callbackRequest) {
            this.callbackRequest = callbackRequest;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallbackConfigKey)) {
                return false;
            }
            CallbackConfigKey other = (CallbackConfigKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CallbackConfigKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            return result;
        }

        public String toString() {
            return "InlineCallbackHandler.CallbackConfigKey(endpoint=" + this.getEndpoint() + ")";
        }

        public CallbackConfigKey(String endpoint, RevolverCallbackRequest callbackRequest) {
            this.endpoint = endpoint;
            this.callbackRequest = callbackRequest;
        }

        public static class CallbackConfigKeyBuilder {
            private String endpoint;
            private RevolverCallbackRequest callbackRequest;

            CallbackConfigKeyBuilder() {
            }

            public CallbackConfigKeyBuilder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public CallbackConfigKeyBuilder callbackRequest(RevolverCallbackRequest callbackRequest) {
                this.callbackRequest = callbackRequest;
                return this;
            }

            public CallbackConfigKey build() {
                return new CallbackConfigKey(this.endpoint, this.callbackRequest);
            }

            public String toString() {
                return "InlineCallbackHandler.CallbackConfigKey.CallbackConfigKeyBuilder(endpoint=" + this.endpoint + ", callbackRequest=" + this.callbackRequest + ")";
            }
        }
    }
}

