/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.confighandler;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.io.ByteStreams;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.confighandler.ConfigLoadInfo;
import io.dropwizard.revolver.confighandler.ConfigSource;
import io.dropwizard.revolver.confighandler.ConfigUpdateEvent;
import io.dropwizard.revolver.confighandler.ConfigUpdateEventListener;
import io.dropwizard.revolver.core.config.RevolverConfigHolder;
import io.dropwizard.revolver.util.CommonUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigHandler
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigHandler.class);
    public static final String DEFAULT_CONFIG_HASH = "unknown";
    private static List<ConfigUpdateEventListener> configUpdateEventListeners = new ArrayList<ConfigUpdateEventListener>();
    private RevolverConfigHolder revolverConfigHolder;
    private ConfigSource configSource;
    private ScheduledExecutorService scheduledExecutorService;
    private ConfigLoadInfo configLoadInfo;
    private ObjectMapper objectMapper;
    private RevolverBundle revolverBundle;
    private static Map<String, ConfigLoadInfo> initialConfigLoadInfos = new HashMap<String, ConfigLoadInfo>();

    public DynamicConfigHandler(RevolverConfigHolder revolverConfigHolder, ObjectMapper objectMapper, ConfigSource configSource, RevolverBundle revolverBundle) {
        this.revolverConfigHolder = revolverConfigHolder;
        this.configSource = configSource;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.revolverBundle = revolverBundle;
        this.objectMapper = objectMapper.copy();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configLoadInfo = new ConfigLoadInfo(new Date());
        try {
            if (configSource == null) {
                this.configLoadInfo.setPreviousConfigHash(DEFAULT_CONFIG_HASH);
            } else {
                JsonNode appConfig = this.loadConfigData();
                String initialHash = CommonUtils.computeHash((String)appConfig.toString());
                this.configLoadInfo.setPreviousConfigHash(initialHash);
                appConfig.fields().forEachRemaining(configAttribute -> initialConfigLoadInfos.put((String)configAttribute.getKey(), ConfigLoadInfo.builder().previousLoadTime(new Date()).previousConfigHash(CommonUtils.computeHash((String)((JsonNode)configAttribute.getValue()).toString())).build()));
            }
            log.info("Initializing dynamic config handler... Config Hash: {}", (Object)this.configLoadInfo.getPreviousConfigHash());
        }
        catch (Exception e) {
            log.error("Error initializing dynamic config handler", (Throwable)e);
        }
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshConfig, 120L, this.revolverConfigHolder.getConfig().getConfigPollIntervalSeconds(), TimeUnit.SECONDS);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    public String refreshConfig() {
        if (this.configSource == null) {
            return DEFAULT_CONFIG_HASH;
        }
        try {
            JsonNode appConfig = this.loadConfigData();
            String curHash = CommonUtils.computeHash((String)appConfig.toString());
            log.info("Old Config Hash: {} | New Config Hash: {}", (Object)this.configLoadInfo.getPreviousConfigHash(), (Object)curHash);
            if (!this.configLoadInfo.getPreviousConfigHash().equals(curHash)) {
                log.info("Refreshing config with new hash: {}", (Object)curHash);
                DynamicConfigHandler.notifyListeners(ConfigUpdateEvent.builder().updatedConfig(appConfig).updatedAt(new Date()).build());
                this.configLoadInfo.setPreviousConfigHash(curHash);
                this.configLoadInfo.setPreviousLoadTime(new Date());
                this.revolverBundle.onConfigChange(appConfig.toString());
                return this.configLoadInfo.getPreviousConfigHash();
            }
            log.info("No config changes detected. Not reloading config..");
            return this.configLoadInfo.getPreviousConfigHash();
        }
        catch (Exception e) {
            log.error("Error fetching configuration", (Throwable)e);
            return null;
        }
    }

    private JsonNode loadConfigData() throws Exception {
        log.info("Fetching configuration from config source. Current Hash: {} | Previous fetch time: {}", (Object)this.configLoadInfo.getPreviousConfigHash(), (Object)this.configLoadInfo.getPreviousLoadTime());
        InputStream inputStream = this.configSource.loadConfigData();
        String config = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
        EnvironmentVariableSubstitutor substitutor = new EnvironmentVariableSubstitutor(false, true);
        String substituted = substitutor.replace(config);
        return (JsonNode)this.objectMapper.readTree((JsonParser)new YAMLFactory().createParser(substituted));
    }

    private static void notifyListeners(ConfigUpdateEvent configUpdateEvent) {
        configUpdateEventListeners.forEach(configUpdateEventListener -> {
            try {
                configUpdateEventListener.configUpdated(configUpdateEvent);
            }
            catch (Exception e) {
                log.error("Error while notifying config update event to listener: {}", configUpdateEventListener, (Object)e);
            }
        });
    }

    public static void registerConfigUpdateEventListener(ConfigUpdateEventListener configUpdateEventListener) {
        try {
            configUpdateEventListeners.add(configUpdateEventListener);
            configUpdateEventListener.initConfigLoadInfo(initialConfigLoadInfos);
        }
        catch (Exception e) {
            log.error("Error while registering config update event listener: {}", (Object)configUpdateEventListener, (Object)e);
        }
    }

    public static void registerConfigUpdateEventListeners(List<ConfigUpdateEventListener> eventListeners) {
        configUpdateEventListeners.addAll(eventListeners);
    }

    public ConfigLoadInfo getConfigLoadInfo() {
        return this.configLoadInfo;
    }
}

