/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.ThreadPoolGroupConfig;
import io.dropwizard.revolver.core.config.sentinel.SentinelCommandConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.http.auth.AuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.splitting.RevolverHttpServiceSplitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class RevolverHttpsServiceConfig
extends RevolverServiceConfig {
    public RevolverHttpsServiceConfig(String type, String service, EndpointSpec endpoint, int connectionPoolSize, boolean authEnabled, AuthConfig auth, String keyStorePath, String keystorePassword, Set<RevolverHttpApiConfig> apis, boolean trackingHeaders, boolean compression, int connectionKeepAliveInMillis, RevolverHttpServiceSplitConfig serviceSplitConfig, SentinelCommandConfig sentinelCommandConfig, ThreadPoolGroupConfig threadPoolGroupConfig) {
        super(type, service, apis, connectionPoolSize, endpoint, authEnabled, auth, true, keystorePassword, keyStorePath, connectionKeepAliveInMillis, serviceSplitConfig, RevolverExecutorType.RESILIENCE, trackingHeaders, compression, threadPoolGroupConfig);
        this.setSentinelCommandConfig(sentinelCommandConfig);
    }

    public static RevolverHttpsServiceConfigBuilder builder() {
        return new RevolverHttpsServiceConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpsServiceConfig)) {
            return false;
        }
        RevolverHttpsServiceConfig other = (RevolverHttpsServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpsServiceConfig;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public RevolverHttpsServiceConfig() {
    }

    public static class RevolverHttpsServiceConfigBuilder {
        private String type;
        private String service;
        private EndpointSpec endpoint;
        private int connectionPoolSize;
        private boolean authEnabled;
        private AuthConfig auth;
        private String keyStorePath;
        private String keystorePassword;
        private ArrayList<RevolverHttpApiConfig> apis;
        private boolean trackingHeaders;
        private boolean compression;
        private int connectionKeepAliveInMillis;
        private RevolverHttpServiceSplitConfig serviceSplitConfig;
        private SentinelCommandConfig sentinelCommandConfig;
        private ThreadPoolGroupConfig threadPoolGroupConfig;

        RevolverHttpsServiceConfigBuilder() {
        }

        public RevolverHttpsServiceConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder service(String service) {
            this.service = service;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder endpoint(EndpointSpec endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder connectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder authEnabled(boolean authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder auth(AuthConfig auth) {
            this.auth = auth;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder api(RevolverHttpApiConfig api) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.add(api);
            return this;
        }

        public RevolverHttpsServiceConfigBuilder apis(Collection<? extends RevolverHttpApiConfig> apis) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.addAll(apis);
            return this;
        }

        public RevolverHttpsServiceConfigBuilder clearApis() {
            if (this.apis != null) {
                this.apis.clear();
            }
            return this;
        }

        public RevolverHttpsServiceConfigBuilder trackingHeaders(boolean trackingHeaders) {
            this.trackingHeaders = trackingHeaders;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder compression(boolean compression) {
            this.compression = compression;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder connectionKeepAliveInMillis(int connectionKeepAliveInMillis) {
            this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder serviceSplitConfig(RevolverHttpServiceSplitConfig serviceSplitConfig) {
            this.serviceSplitConfig = serviceSplitConfig;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder sentinelCommandConfig(SentinelCommandConfig sentinelCommandConfig) {
            this.sentinelCommandConfig = sentinelCommandConfig;
            return this;
        }

        public RevolverHttpsServiceConfigBuilder threadPoolGroupConfig(ThreadPoolGroupConfig threadPoolGroupConfig) {
            this.threadPoolGroupConfig = threadPoolGroupConfig;
            return this;
        }

        public RevolverHttpsServiceConfig build() {
            Set<Object> apis;
            switch (this.apis == null ? 0 : this.apis.size()) {
                case 0: {
                    apis = Collections.emptySet();
                    break;
                }
                case 1: {
                    apis = Collections.singleton(this.apis.get(0));
                    break;
                }
                default: {
                    apis = new LinkedHashSet(this.apis.size() < 0x40000000 ? 1 + this.apis.size() + (this.apis.size() - 3) / 3 : Integer.MAX_VALUE);
                    apis.addAll(this.apis);
                    apis = Collections.unmodifiableSet(apis);
                }
            }
            return new RevolverHttpsServiceConfig(this.type, this.service, this.endpoint, this.connectionPoolSize, this.authEnabled, this.auth, this.keyStorePath, this.keystorePassword, apis, this.trackingHeaders, this.compression, this.connectionKeepAliveInMillis, this.serviceSplitConfig, this.sentinelCommandConfig, this.threadPoolGroupConfig);
        }

        public String toString() {
            return "RevolverHttpsServiceConfig.RevolverHttpsServiceConfigBuilder(type=" + this.type + ", service=" + this.service + ", endpoint=" + this.endpoint + ", connectionPoolSize=" + this.connectionPoolSize + ", authEnabled=" + this.authEnabled + ", auth=" + this.auth + ", keyStorePath=" + this.keyStorePath + ", keystorePassword=" + this.keystorePassword + ", apis=" + this.apis + ", trackingHeaders=" + this.trackingHeaders + ", compression=" + this.compression + ", connectionKeepAliveInMillis=" + this.connectionKeepAliveInMillis + ", serviceSplitConfig=" + this.serviceSplitConfig + ", sentinelCommandConfig=" + this.sentinelCommandConfig + ", threadPoolGroupConfig=" + this.threadPoolGroupConfig + ")";
        }
    }
}

