/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.sentinel.SentinelCommandConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.http.auth.AuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.splitting.RevolverHttpServiceSplitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class RevolverHttpServiceConfig
extends RevolverServiceConfig {
    public RevolverHttpServiceConfig(String type, String service, EndpointSpec endpoint, int connectionPoolSize, boolean authEnabled, boolean secured, AuthConfig auth, String keyStorePath, String keystorePassword, Set<RevolverHttpApiConfig> apis, boolean trackingHeaders, boolean compression, int connectionKeepAliveInMillis, RevolverHttpServiceSplitConfig serviceSplitConfig, SentinelCommandConfig sentinelCommandConfig, RevolverExecutorType revolverExecutorType) {
        super(type, service, apis, connectionPoolSize, endpoint, authEnabled, auth, secured, keystorePassword, keyStorePath, connectionKeepAliveInMillis, serviceSplitConfig, revolverExecutorType, trackingHeaders, compression);
        this.setSentinelCommandConfig(sentinelCommandConfig);
    }

    public static RevolverHttpServiceConfigBuilder builder() {
        return new RevolverHttpServiceConfigBuilder();
    }

    public RevolverHttpServiceConfig() {
    }

    @Override
    public String toString() {
        return "RevolverHttpServiceConfig(super=" + super.toString() + ")";
    }

    public static class RevolverHttpServiceConfigBuilder {
        private String type;
        private String service;
        private EndpointSpec endpoint;
        private int connectionPoolSize;
        private boolean authEnabled;
        private boolean secured;
        private AuthConfig auth;
        private String keyStorePath;
        private String keystorePassword;
        private ArrayList<RevolverHttpApiConfig> apis;
        private boolean trackingHeaders;
        private boolean compression;
        private int connectionKeepAliveInMillis;
        private RevolverHttpServiceSplitConfig serviceSplitConfig;
        private SentinelCommandConfig sentinelCommandConfig;
        private RevolverExecutorType revolverExecutorType;

        RevolverHttpServiceConfigBuilder() {
        }

        public RevolverHttpServiceConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevolverHttpServiceConfigBuilder service(String service) {
            this.service = service;
            return this;
        }

        public RevolverHttpServiceConfigBuilder endpoint(EndpointSpec endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public RevolverHttpServiceConfigBuilder connectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public RevolverHttpServiceConfigBuilder authEnabled(boolean authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        public RevolverHttpServiceConfigBuilder secured(boolean secured) {
            this.secured = secured;
            return this;
        }

        public RevolverHttpServiceConfigBuilder auth(AuthConfig auth) {
            this.auth = auth;
            return this;
        }

        public RevolverHttpServiceConfigBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public RevolverHttpServiceConfigBuilder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public RevolverHttpServiceConfigBuilder api(RevolverHttpApiConfig api) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.add(api);
            return this;
        }

        public RevolverHttpServiceConfigBuilder apis(Collection<? extends RevolverHttpApiConfig> apis) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.addAll(apis);
            return this;
        }

        public RevolverHttpServiceConfigBuilder clearApis() {
            if (this.apis != null) {
                this.apis.clear();
            }
            return this;
        }

        public RevolverHttpServiceConfigBuilder trackingHeaders(boolean trackingHeaders) {
            this.trackingHeaders = trackingHeaders;
            return this;
        }

        public RevolverHttpServiceConfigBuilder compression(boolean compression) {
            this.compression = compression;
            return this;
        }

        public RevolverHttpServiceConfigBuilder connectionKeepAliveInMillis(int connectionKeepAliveInMillis) {
            this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
            return this;
        }

        public RevolverHttpServiceConfigBuilder serviceSplitConfig(RevolverHttpServiceSplitConfig serviceSplitConfig) {
            this.serviceSplitConfig = serviceSplitConfig;
            return this;
        }

        public RevolverHttpServiceConfigBuilder sentinelCommandConfig(SentinelCommandConfig sentinelCommandConfig) {
            this.sentinelCommandConfig = sentinelCommandConfig;
            return this;
        }

        public RevolverHttpServiceConfigBuilder revolverExecutorType(RevolverExecutorType revolverExecutorType) {
            this.revolverExecutorType = revolverExecutorType;
            return this;
        }

        public RevolverHttpServiceConfig build() {
            Set<Object> apis;
            switch (this.apis == null ? 0 : this.apis.size()) {
                case 0: {
                    apis = Collections.emptySet();
                    break;
                }
                case 1: {
                    apis = Collections.singleton(this.apis.get(0));
                    break;
                }
                default: {
                    apis = new LinkedHashSet(this.apis.size() < 0x40000000 ? 1 + this.apis.size() + (this.apis.size() - 3) / 3 : Integer.MAX_VALUE);
                    apis.addAll(this.apis);
                    apis = Collections.unmodifiableSet(apis);
                }
            }
            return new RevolverHttpServiceConfig(this.type, this.service, this.endpoint, this.connectionPoolSize, this.authEnabled, this.secured, this.auth, this.keyStorePath, this.keystorePassword, apis, this.trackingHeaders, this.compression, this.connectionKeepAliveInMillis, this.serviceSplitConfig, this.sentinelCommandConfig, this.revolverExecutorType);
        }

        public String toString() {
            return "RevolverHttpServiceConfig.RevolverHttpServiceConfigBuilder(type=" + this.type + ", service=" + this.service + ", endpoint=" + this.endpoint + ", connectionPoolSize=" + this.connectionPoolSize + ", authEnabled=" + this.authEnabled + ", secured=" + this.secured + ", auth=" + this.auth + ", keyStorePath=" + this.keyStorePath + ", keystorePassword=" + this.keystorePassword + ", apis=" + this.apis + ", trackingHeaders=" + this.trackingHeaders + ", compression=" + this.compression + ", connectionKeepAliveInMillis=" + this.connectionKeepAliveInMillis + ", serviceSplitConfig=" + this.serviceSplitConfig + ", sentinelCommandConfig=" + this.sentinelCommandConfig + ", revolverExecutorType=" + (Object)((Object)this.revolverExecutorType) + ")";
        }
    }
}

