/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.model;

import io.dropwizard.revolver.core.model.RevolverServiceMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RevolverMetadataResponse {
    List<RevolverServiceMetadata> services;
    private String clientId;

    public static RevolverMetadataResponseBuilder builder() {
        return new RevolverMetadataResponseBuilder();
    }

    public List<RevolverServiceMetadata> getServices() {
        return this.services;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setServices(List<RevolverServiceMetadata> services) {
        this.services = services;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverMetadataResponse)) {
            return false;
        }
        RevolverMetadataResponse other = (RevolverMetadataResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RevolverServiceMetadata> this$services = this.getServices();
        List<RevolverServiceMetadata> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverMetadataResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RevolverServiceMetadata> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        return result;
    }

    public String toString() {
        return "RevolverMetadataResponse(services=" + this.getServices() + ", clientId=" + this.getClientId() + ")";
    }

    public RevolverMetadataResponse(List<RevolverServiceMetadata> services, String clientId) {
        this.services = services;
        this.clientId = clientId;
    }

    public RevolverMetadataResponse() {
    }

    public static class RevolverMetadataResponseBuilder {
        private ArrayList<RevolverServiceMetadata> services;
        private String clientId;

        RevolverMetadataResponseBuilder() {
        }

        public RevolverMetadataResponseBuilder service(RevolverServiceMetadata service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public RevolverMetadataResponseBuilder services(Collection<? extends RevolverServiceMetadata> services) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public RevolverMetadataResponseBuilder clearServices() {
            if (this.services != null) {
                this.services.clear();
            }
            return this;
        }

        public RevolverMetadataResponseBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RevolverMetadataResponse build() {
            List<RevolverServiceMetadata> services;
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<RevolverServiceMetadata>(this.services));
                }
            }
            return new RevolverMetadataResponse(services, this.clientId);
        }

        public String toString() {
            return "RevolverMetadataResponse.RevolverMetadataResponseBuilder(services=" + this.services + ", clientId=" + this.clientId + ")";
        }
    }
}

