/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.config;

public class ServiceDiscoveryConfig {
    private boolean watcherDisabled;
    private int refreshTimeInMs;
    private int waitForDiscoveryInMs;

    private static boolean $default$watcherDisabled() {
        return false;
    }

    private static int $default$refreshTimeInMs() {
        return 1000;
    }

    private static int $default$waitForDiscoveryInMs() {
        return 0;
    }

    public static ServiceDiscoveryConfigBuilder builder() {
        return new ServiceDiscoveryConfigBuilder();
    }

    public boolean isWatcherDisabled() {
        return this.watcherDisabled;
    }

    public int getRefreshTimeInMs() {
        return this.refreshTimeInMs;
    }

    public int getWaitForDiscoveryInMs() {
        return this.waitForDiscoveryInMs;
    }

    public void setWatcherDisabled(boolean watcherDisabled) {
        this.watcherDisabled = watcherDisabled;
    }

    public void setRefreshTimeInMs(int refreshTimeInMs) {
        this.refreshTimeInMs = refreshTimeInMs;
    }

    public void setWaitForDiscoveryInMs(int waitForDiscoveryInMs) {
        this.waitForDiscoveryInMs = waitForDiscoveryInMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDiscoveryConfig)) {
            return false;
        }
        ServiceDiscoveryConfig other = (ServiceDiscoveryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWatcherDisabled() != other.isWatcherDisabled()) {
            return false;
        }
        if (this.getRefreshTimeInMs() != other.getRefreshTimeInMs()) {
            return false;
        }
        return this.getWaitForDiscoveryInMs() == other.getWaitForDiscoveryInMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceDiscoveryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWatcherDisabled() ? 79 : 97);
        result = result * 59 + this.getRefreshTimeInMs();
        result = result * 59 + this.getWaitForDiscoveryInMs();
        return result;
    }

    public String toString() {
        return "ServiceDiscoveryConfig(watcherDisabled=" + this.isWatcherDisabled() + ", refreshTimeInMs=" + this.getRefreshTimeInMs() + ", waitForDiscoveryInMs=" + this.getWaitForDiscoveryInMs() + ")";
    }

    public ServiceDiscoveryConfig() {
    }

    public ServiceDiscoveryConfig(boolean watcherDisabled, int refreshTimeInMs, int waitForDiscoveryInMs) {
        this.watcherDisabled = watcherDisabled;
        this.refreshTimeInMs = refreshTimeInMs;
        this.waitForDiscoveryInMs = waitForDiscoveryInMs;
    }

    public static class ServiceDiscoveryConfigBuilder {
        private boolean watcherDisabled$set;
        private boolean watcherDisabled;
        private boolean refreshTimeInMs$set;
        private int refreshTimeInMs;
        private boolean waitForDiscoveryInMs$set;
        private int waitForDiscoveryInMs;

        ServiceDiscoveryConfigBuilder() {
        }

        public ServiceDiscoveryConfigBuilder watcherDisabled(boolean watcherDisabled) {
            this.watcherDisabled = watcherDisabled;
            this.watcherDisabled$set = true;
            return this;
        }

        public ServiceDiscoveryConfigBuilder refreshTimeInMs(int refreshTimeInMs) {
            this.refreshTimeInMs = refreshTimeInMs;
            this.refreshTimeInMs$set = true;
            return this;
        }

        public ServiceDiscoveryConfigBuilder waitForDiscoveryInMs(int waitForDiscoveryInMs) {
            this.waitForDiscoveryInMs = waitForDiscoveryInMs;
            this.waitForDiscoveryInMs$set = true;
            return this;
        }

        public ServiceDiscoveryConfig build() {
            boolean watcherDisabled = this.watcherDisabled;
            if (!this.watcherDisabled$set) {
                watcherDisabled = ServiceDiscoveryConfig.$default$watcherDisabled();
            }
            int refreshTimeInMs = this.refreshTimeInMs;
            if (!this.refreshTimeInMs$set) {
                refreshTimeInMs = ServiceDiscoveryConfig.$default$refreshTimeInMs();
            }
            int waitForDiscoveryInMs = this.waitForDiscoveryInMs;
            if (!this.waitForDiscoveryInMs$set) {
                waitForDiscoveryInMs = ServiceDiscoveryConfig.$default$waitForDiscoveryInMs();
            }
            return new ServiceDiscoveryConfig(watcherDisabled, refreshTimeInMs, waitForDiscoveryInMs);
        }

        public String toString() {
            return "ServiceDiscoveryConfig.ServiceDiscoveryConfigBuilder(watcherDisabled=" + this.watcherDisabled + ", refreshTimeInMs=" + this.refreshTimeInMs + ", waitForDiscoveryInMs=" + this.waitForDiscoveryInMs + ")";
        }
    }
}

