/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.config.hystrix;

import javax.validation.constraints.Max;

public class MetricsConfig {
    @Max(value=60000L)
    private int statsTimeInMillis = 60000;
    private int statsBucketSize = 100;
    private int healthCheckInterval = 500;
    private int percentileTimeInMillis = 60000;
    private int percentileBucketSize = 100;
    private double corePoolSizeReductionParam = 0.75;

    public static MetricsConfigBuilder builder() {
        return new MetricsConfigBuilder();
    }

    public int getStatsTimeInMillis() {
        return this.statsTimeInMillis;
    }

    public int getStatsBucketSize() {
        return this.statsBucketSize;
    }

    public int getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public int getPercentileTimeInMillis() {
        return this.percentileTimeInMillis;
    }

    public int getPercentileBucketSize() {
        return this.percentileBucketSize;
    }

    public double getCorePoolSizeReductionParam() {
        return this.corePoolSizeReductionParam;
    }

    public void setStatsTimeInMillis(int statsTimeInMillis) {
        this.statsTimeInMillis = statsTimeInMillis;
    }

    public void setStatsBucketSize(int statsBucketSize) {
        this.statsBucketSize = statsBucketSize;
    }

    public void setHealthCheckInterval(int healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    public void setPercentileTimeInMillis(int percentileTimeInMillis) {
        this.percentileTimeInMillis = percentileTimeInMillis;
    }

    public void setPercentileBucketSize(int percentileBucketSize) {
        this.percentileBucketSize = percentileBucketSize;
    }

    public void setCorePoolSizeReductionParam(double corePoolSizeReductionParam) {
        this.corePoolSizeReductionParam = corePoolSizeReductionParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsConfig)) {
            return false;
        }
        MetricsConfig other = (MetricsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatsTimeInMillis() != other.getStatsTimeInMillis()) {
            return false;
        }
        if (this.getStatsBucketSize() != other.getStatsBucketSize()) {
            return false;
        }
        if (this.getHealthCheckInterval() != other.getHealthCheckInterval()) {
            return false;
        }
        if (this.getPercentileTimeInMillis() != other.getPercentileTimeInMillis()) {
            return false;
        }
        if (this.getPercentileBucketSize() != other.getPercentileBucketSize()) {
            return false;
        }
        return Double.compare(this.getCorePoolSizeReductionParam(), other.getCorePoolSizeReductionParam()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatsTimeInMillis();
        result = result * 59 + this.getStatsBucketSize();
        result = result * 59 + this.getHealthCheckInterval();
        result = result * 59 + this.getPercentileTimeInMillis();
        result = result * 59 + this.getPercentileBucketSize();
        long $corePoolSizeReductionParam = Double.doubleToLongBits(this.getCorePoolSizeReductionParam());
        result = result * 59 + (int)($corePoolSizeReductionParam >>> 32 ^ $corePoolSizeReductionParam);
        return result;
    }

    public String toString() {
        return "MetricsConfig(statsTimeInMillis=" + this.getStatsTimeInMillis() + ", statsBucketSize=" + this.getStatsBucketSize() + ", healthCheckInterval=" + this.getHealthCheckInterval() + ", percentileTimeInMillis=" + this.getPercentileTimeInMillis() + ", percentileBucketSize=" + this.getPercentileBucketSize() + ", corePoolSizeReductionParam=" + this.getCorePoolSizeReductionParam() + ")";
    }

    public MetricsConfig(int statsTimeInMillis, int statsBucketSize, int healthCheckInterval, int percentileTimeInMillis, int percentileBucketSize, double corePoolSizeReductionParam) {
        this.statsTimeInMillis = statsTimeInMillis;
        this.statsBucketSize = statsBucketSize;
        this.healthCheckInterval = healthCheckInterval;
        this.percentileTimeInMillis = percentileTimeInMillis;
        this.percentileBucketSize = percentileBucketSize;
        this.corePoolSizeReductionParam = corePoolSizeReductionParam;
    }

    public MetricsConfig() {
    }

    public static class MetricsConfigBuilder {
        private int statsTimeInMillis;
        private int statsBucketSize;
        private int healthCheckInterval;
        private int percentileTimeInMillis;
        private int percentileBucketSize;
        private double corePoolSizeReductionParam;

        MetricsConfigBuilder() {
        }

        public MetricsConfigBuilder statsTimeInMillis(int statsTimeInMillis) {
            this.statsTimeInMillis = statsTimeInMillis;
            return this;
        }

        public MetricsConfigBuilder statsBucketSize(int statsBucketSize) {
            this.statsBucketSize = statsBucketSize;
            return this;
        }

        public MetricsConfigBuilder healthCheckInterval(int healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
            return this;
        }

        public MetricsConfigBuilder percentileTimeInMillis(int percentileTimeInMillis) {
            this.percentileTimeInMillis = percentileTimeInMillis;
            return this;
        }

        public MetricsConfigBuilder percentileBucketSize(int percentileBucketSize) {
            this.percentileBucketSize = percentileBucketSize;
            return this;
        }

        public MetricsConfigBuilder corePoolSizeReductionParam(double corePoolSizeReductionParam) {
            this.corePoolSizeReductionParam = corePoolSizeReductionParam;
            return this;
        }

        public MetricsConfig build() {
            return new MetricsConfig(this.statsTimeInMillis, this.statsBucketSize, this.healthCheckInterval, this.percentileTimeInMillis, this.percentileBucketSize, this.corePoolSizeReductionParam);
        }

        public String toString() {
            return "MetricsConfig.MetricsConfigBuilder(statsTimeInMillis=" + this.statsTimeInMillis + ", statsBucketSize=" + this.statsBucketSize + ", healthCheckInterval=" + this.healthCheckInterval + ", percentileTimeInMillis=" + this.percentileTimeInMillis + ", percentileBucketSize=" + this.percentileBucketSize + ", corePoolSizeReductionParam=" + this.corePoolSizeReductionParam + ")";
        }
    }
}

