/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.resilience;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverContext;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.resilience.ResilienceHttpContext;
import io.dropwizard.revolver.core.resilience.ResilienceUtil;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilienceCommandHelper<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig> {
    private static final Logger log = LoggerFactory.getLogger(ResilienceCommandHelper.class);
    private static final long DEFAULT_TTL = 5000L;
    private final RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler;
    private final RequestType request;
    private final ContextType context;

    public ResilienceCommandHelper(ContextType context, RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler, RequestType request) {
        this.context = context;
        this.handler = handler;
        this.request = request;
    }

    public ResponseType executeSync() throws Exception {
        try {
            return this.execute();
        }
        catch (Exception e) {
            if (e instanceof BulkheadFullException) {
                log.error("BulkheadFullException occurred");
                this.registerMetric();
            }
            throw e;
        }
    }

    public CompletableFuture<ResponseType> executeASync() {
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.execute();
                }
                catch (Exception e) {
                    throw this.getException(e);
                }
            });
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private ResponseType execute() throws Exception {
        ResilienceHttpContext resilienceHttpContext = this.getResilienceContext();
        CircuitBreaker circuitBreaker = this.getCircuitBreaker(resilienceHttpContext, this.request, this.handler.getServiceConfiguration(), this.handler.getApiConfiguration());
        Bulkhead bulkhead = this.getBulkHead(resilienceHttpContext, this.request, this.handler.getServiceConfiguration());
        TimeLimiter timeLimiter = this.getTimeoutConfig(resilienceHttpContext, this.handler.getServiceConfiguration(), this.handler.getApiConfiguration());
        Supplier<Future> supplier = () -> resilienceHttpContext.getExecutor().submit(() -> this.handler.execute(this.context, this.request));
        Callable timeCallable = TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, supplier);
        Callable circuitCallable = CircuitBreaker.decorateCallable((CircuitBreaker)circuitBreaker, (Callable)timeCallable);
        Callable bulkHeadCallable = Bulkhead.decorateCallable((Bulkhead)bulkhead, (Callable)circuitCallable);
        return (ResponseType)((RevolverResponse)bulkHeadCallable.call());
    }

    private ResilienceHttpContext getResilienceContext() {
        ResilienceHttpContext resilienceHttpContext = this.context instanceof ResilienceHttpContext ? (ResilienceHttpContext)this.context : new ResilienceHttpContext();
        return resilienceHttpContext;
    }

    private String getThreadPoolName() {
        ThreadPoolConfig threadPoolConfig = ((CommandHandlerConfig)this.handler.getApiConfiguration()).getRuntime().getThreadPool();
        String threadPoolName = threadPoolConfig.getThreadPoolName();
        if (StringUtils.isEmpty((CharSequence)threadPoolName)) {
            return ((RevolverRequest)this.request).getService() + "." + ((RevolverRequest)this.request).getApi();
        }
        return ResilienceUtil.getThreadPoolNameForService(((RevolverRequest)this.request).getService(), threadPoolName);
    }

    private TimeLimiter getTimeoutConfig(ResilienceHttpContext resilienceHttpContext, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigurationType apiConfiguration) {
        String apiName;
        Map<String, Integer> apiVsTimeout = resilienceHttpContext.getApiVsTimeout();
        long ttl = 0L;
        if (apiConfiguration instanceof RevolverHttpApiConfig && apiVsTimeout.get(apiName = ResilienceUtil.getApiName(serviceConfiguration, (RevolverHttpApiConfig)apiConfiguration)) != null) {
            ttl = apiVsTimeout.get(apiName).intValue();
        }
        if (ttl == 0L) {
            log.info("Timeout not set for api : {}", (Object)((CommandHandlerConfig)apiConfiguration).getApi());
            ttl = 5000L;
        }
        TimeLimiterConfig config = TimeLimiterConfig.custom().timeoutDuration(Duration.ofMillis(ttl)).build();
        return TimeLimiter.of((TimeLimiterConfig)config);
    }

    private Bulkhead getBulkHead(ResilienceHttpContext resilienceHttpContext, RequestType request, ServiceConfigurationType serviceConfiguration) {
        String threadPoolName;
        Map<String, Bulkhead> bulkheadMap = resilienceHttpContext.getPoolVsBulkHeadMap();
        Bulkhead bulkhead = bulkheadMap.get(threadPoolName = this.getThreadPoolName());
        if (bulkhead != null) {
            log.debug("BulkheadName : {},  Available Calls : {}, Max Calls : {}, Wait Time : {}", new Object[]{bulkhead.getName(), bulkhead.getMetrics().getAvailableConcurrentCalls(), bulkhead.getMetrics().getMaxAllowedConcurrentCalls(), bulkhead.getBulkheadConfig().getMaxWaitDuration()});
            return bulkhead;
        }
        log.info("No bulk head defined for threadPool : {} service : {}, api : {}", new Object[]{threadPoolName, ((RevolverRequest)request).getService(), ((RevolverRequest)request).getApi()});
        threadPoolName = ((RevolverServiceConfig)serviceConfiguration).getService();
        if (StringUtils.isNotEmpty((CharSequence)threadPoolName)) {
            bulkhead = bulkheadMap.get(threadPoolName);
        }
        if (bulkhead == null) {
            log.info("No bulk head defined for service : {}, api : {} threadPool : {}", new Object[]{((RevolverRequest)request).getService(), ((RevolverRequest)request).getApi(), threadPoolName});
            bulkhead = Bulkhead.ofDefaults((String)"revolver");
        }
        return bulkhead;
    }

    private RevolverExecutionException getException(Throwable throwable) {
        return new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing resilience command %s", RevolverCommandHelper.getName(this.request)), RevolverExceptionHelper.getLeafThrowable(throwable));
    }

    private CircuitBreaker getCircuitBreaker(ResilienceHttpContext resilienceHttpContext, RequestType request, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigurationType apiConfiguration) {
        String cbName;
        Map<String, CircuitBreaker> circuitBreakerMap = resilienceHttpContext.getApiVsCircuitBreaker();
        CircuitBreaker circuitBreaker = circuitBreakerMap.get(cbName = apiConfiguration instanceof RevolverHttpApiConfig ? ResilienceUtil.getCbName(serviceConfiguration, (RevolverHttpApiConfig)apiConfiguration) : ((RevolverServiceConfig)serviceConfiguration).getService());
        if (circuitBreaker != null) {
            return circuitBreaker;
        }
        log.info("No circuit breaker defined for service {}, api {}", (Object)((RevolverRequest)request).getService(), (Object)((RevolverRequest)request).getApi());
        circuitBreaker = resilienceHttpContext.getDefaultCircuitBreaker();
        return circuitBreaker;
    }

    private String getMetricName() {
        return "BulkheadFullException." + this.getThreadPoolName();
    }

    private void registerMetric() {
        if (this.getResilienceContext().getMetrics() == null) {
            return;
        }
        MetricRegistry metrics = this.getResilienceContext().getMetrics();
        Meter meter = metrics.meter(this.getMetricName());
        if (meter != null) {
            meter.mark();
        }
    }
}

