/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponses;
import io.dropwizard.revolver.exception.RevolverException;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.util.ResponseTransformationUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
@Api(value="MailBox APIs V2", description="Revolver gateway api v2 for interacting mailbox requests")
public class RevolverMailboxResourceV2 {
    private static final Logger log = LoggerFactory.getLogger(RevolverMailboxResourceV2.class);
    private static final RevolverException NOT_FOUND_ERROR = RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
    private static final RevolverException SERVER_ERROR = RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message("Oops! Something went wrong!").build();
    private PersistenceProvider persistenceProvider;
    private ObjectMapper jsonObjectMapper;
    private ObjectMapper msgPackObjectMapper;
    private Map<String, RevolverHttpApiConfig> apiConfig;

    @Path(value="/v2/requests")
    @GET
    @Metered
    @ApiOperation(value="Get all the requests in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response requests(@HeaderParam(value="X-MAILBOX-AUTH-ID") String mailboxAuthId, @Context HttpHeaders headers) throws RevolverException {
        try {
            List<RevolverCallbackRequest> callbackRequests = this.persistenceProvider.requestsByMailboxAuth(mailboxAuthId);
            if (callbackRequests == null) {
                throw NOT_FOUND_ERROR;
            }
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(callbackRequests, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(callbackRequests, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting requests", (Throwable)e);
            throw SERVER_ERROR;
        }
    }

    @Path(value="/v2/responses")
    @GET
    @Metered
    @ApiOperation(value="Get all the responses in the mailbox")
    @Produces(value={"application/json", "application/msgpack", "application/xml", "text/html"})
    public Response responses(@HeaderParam(value="X-MAILBOX-AUTH-ID") String mailboxAuthId, @Context HttpHeaders headers) throws RevolverException {
        try {
            if (Strings.isNullOrEmpty((String)mailboxAuthId)) {
                throw RevolverException.builder().status(Response.Status.BAD_REQUEST.getStatusCode()).message("Invalid Mailbox Id").errorCode("R003").build();
            }
            List<RevolverCallbackResponses> callbackResponses = this.persistenceProvider.responsesByMailboxAuth(mailboxAuthId);
            if (callbackResponses == null) {
                throw NOT_FOUND_ERROR;
            }
            if (headers.getAcceptableMediaTypes().size() == 0) {
                return Response.ok((Object)ResponseTransformationUtil.transform(callbackResponses, "application/json", this.jsonObjectMapper, this.msgPackObjectMapper), (String)"application/json").build();
            }
            return Response.ok((Object)ResponseTransformationUtil.transform(callbackResponses, ((MediaType)headers.getAcceptableMediaTypes().get(0)).toString(), this.jsonObjectMapper, this.msgPackObjectMapper), (String)((MediaType)headers.getAcceptableMediaTypes().get(0)).toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting responses", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    public static RevolverMailboxResourceV2Builder builder() {
        return new RevolverMailboxResourceV2Builder();
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonObjectMapper;
    }

    public ObjectMapper getMsgPackObjectMapper() {
        return this.msgPackObjectMapper;
    }

    public Map<String, RevolverHttpApiConfig> getApiConfig() {
        return this.apiConfig;
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public void setJsonObjectMapper(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public void setMsgPackObjectMapper(ObjectMapper msgPackObjectMapper) {
        this.msgPackObjectMapper = msgPackObjectMapper;
    }

    public void setApiConfig(Map<String, RevolverHttpApiConfig> apiConfig) {
        this.apiConfig = apiConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverMailboxResourceV2)) {
            return false;
        }
        RevolverMailboxResourceV2 other = (RevolverMailboxResourceV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PersistenceProvider this$persistenceProvider = this.getPersistenceProvider();
        PersistenceProvider other$persistenceProvider = other.getPersistenceProvider();
        if (this$persistenceProvider == null ? other$persistenceProvider != null : !this$persistenceProvider.equals(other$persistenceProvider)) {
            return false;
        }
        ObjectMapper this$jsonObjectMapper = this.getJsonObjectMapper();
        ObjectMapper other$jsonObjectMapper = other.getJsonObjectMapper();
        if (this$jsonObjectMapper == null ? other$jsonObjectMapper != null : !this$jsonObjectMapper.equals(other$jsonObjectMapper)) {
            return false;
        }
        ObjectMapper this$msgPackObjectMapper = this.getMsgPackObjectMapper();
        ObjectMapper other$msgPackObjectMapper = other.getMsgPackObjectMapper();
        if (this$msgPackObjectMapper == null ? other$msgPackObjectMapper != null : !this$msgPackObjectMapper.equals(other$msgPackObjectMapper)) {
            return false;
        }
        Map<String, RevolverHttpApiConfig> this$apiConfig = this.getApiConfig();
        Map<String, RevolverHttpApiConfig> other$apiConfig = other.getApiConfig();
        return !(this$apiConfig == null ? other$apiConfig != null : !((Object)this$apiConfig).equals(other$apiConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverMailboxResourceV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PersistenceProvider $persistenceProvider = this.getPersistenceProvider();
        result = result * 59 + ($persistenceProvider == null ? 43 : $persistenceProvider.hashCode());
        ObjectMapper $jsonObjectMapper = this.getJsonObjectMapper();
        result = result * 59 + ($jsonObjectMapper == null ? 43 : $jsonObjectMapper.hashCode());
        ObjectMapper $msgPackObjectMapper = this.getMsgPackObjectMapper();
        result = result * 59 + ($msgPackObjectMapper == null ? 43 : $msgPackObjectMapper.hashCode());
        Map<String, RevolverHttpApiConfig> $apiConfig = this.getApiConfig();
        result = result * 59 + ($apiConfig == null ? 43 : ((Object)$apiConfig).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverMailboxResourceV2(persistenceProvider=" + this.getPersistenceProvider() + ", jsonObjectMapper=" + this.getJsonObjectMapper() + ", msgPackObjectMapper=" + this.getMsgPackObjectMapper() + ", apiConfig=" + this.getApiConfig() + ")";
    }

    public RevolverMailboxResourceV2(PersistenceProvider persistenceProvider, ObjectMapper jsonObjectMapper, ObjectMapper msgPackObjectMapper, Map<String, RevolverHttpApiConfig> apiConfig) {
        this.persistenceProvider = persistenceProvider;
        this.jsonObjectMapper = jsonObjectMapper;
        this.msgPackObjectMapper = msgPackObjectMapper;
        this.apiConfig = apiConfig;
    }

    public static class RevolverMailboxResourceV2Builder {
        private PersistenceProvider persistenceProvider;
        private ObjectMapper jsonObjectMapper;
        private ObjectMapper msgPackObjectMapper;
        private Map<String, RevolverHttpApiConfig> apiConfig;

        RevolverMailboxResourceV2Builder() {
        }

        public RevolverMailboxResourceV2Builder persistenceProvider(PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public RevolverMailboxResourceV2Builder jsonObjectMapper(ObjectMapper jsonObjectMapper) {
            this.jsonObjectMapper = jsonObjectMapper;
            return this;
        }

        public RevolverMailboxResourceV2Builder msgPackObjectMapper(ObjectMapper msgPackObjectMapper) {
            this.msgPackObjectMapper = msgPackObjectMapper;
            return this;
        }

        public RevolverMailboxResourceV2Builder apiConfig(Map<String, RevolverHttpApiConfig> apiConfig) {
            this.apiConfig = apiConfig;
            return this;
        }

        public RevolverMailboxResourceV2 build() {
            return new RevolverMailboxResourceV2(this.persistenceProvider, this.jsonObjectMapper, this.msgPackObjectMapper, this.apiConfig);
        }

        public String toString() {
            return "RevolverMailboxResourceV2.RevolverMailboxResourceV2Builder(persistenceProvider=" + this.persistenceProvider + ", jsonObjectMapper=" + this.jsonObjectMapper + ", msgPackObjectMapper=" + this.msgPackObjectMapper + ", apiConfig=" + this.apiConfig + ")";
        }
    }
}

