/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.persistence;

import com.google.common.base.Strings;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverCallbackResponses;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class InMemoryPersistenceProvider
implements PersistenceProvider {
    private final ConcurrentHashMap<String, RevolverCallbackRequest> callbackRequests = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RevolverCallbackResponse> callbackResponse = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RevolverRequestState> callbackStates = new ConcurrentHashMap();
    private final MultivaluedMap<String, String> mailbox = new MultivaluedHashMap();
    private final MultivaluedMap<String, String> mailboxAuth = new MultivaluedHashMap();
    private final ConcurrentHashMap<String, String> requestToMailboxAuthMap = new ConcurrentHashMap();

    @Override
    public boolean exists(String requestId) {
        return this.callbackRequests.containsKey(requestId);
    }

    @Override
    public void saveRequest(String requestId, String mailBoxId, String mailboxAuthId, RevolverCallbackRequest request) {
        this.callbackRequests.put(requestId, request);
        if (!StringUtils.isBlank((CharSequence)mailBoxId)) {
            this.mailbox.add((Object)mailBoxId, (Object)requestId);
        }
        if (!StringUtils.isBlank((CharSequence)mailboxAuthId)) {
            this.mailboxAuth.add((Object)mailboxAuthId, (Object)requestId);
            this.requestToMailboxAuthMap.put(requestId, mailboxAuthId);
        }
        this.callbackStates.put(requestId, RevolverRequestState.RECEIVED);
    }

    @Override
    public void saveRequest(String requestId, String mailBoxId, String mailboxAuthId, RevolverCallbackRequest request, int ttl) {
        this.callbackRequests.put(requestId, request);
        if (!StringUtils.isBlank((CharSequence)mailBoxId)) {
            this.mailbox.add((Object)mailBoxId, (Object)requestId);
        }
        if (!StringUtils.isBlank((CharSequence)mailboxAuthId)) {
            this.mailboxAuth.add((Object)mailboxAuthId, (Object)requestId);
            this.requestToMailboxAuthMap.put(requestId, mailboxAuthId);
        }
        this.callbackStates.put(requestId, RevolverRequestState.RECEIVED);
    }

    @Override
    public void setRequestState(String requestId, RevolverRequestState state, int ttl) {
        this.callbackStates.put(requestId, state);
    }

    @Override
    public void saveResponse(String requestId, RevolverCallbackResponse response, int ttl) {
        this.callbackResponse.put(requestId, response);
        this.callbackStates.put(requestId, RevolverRequestState.RESPONDED);
    }

    @Override
    public RevolverRequestState requestState(String requestId) {
        return this.callbackStates.get(requestId);
    }

    @Override
    public RevolverCallbackRequest request(String requestId) {
        return this.callbackRequests.get(requestId);
    }

    @Override
    public RevolverRequestState requestState(String requestId, String mailBoxAuthId) {
        if (this.isInvalidMailboxAuthId(requestId, mailBoxAuthId)) {
            return RevolverRequestState.UNKNOWN;
        }
        return this.callbackStates.get(requestId);
    }

    private boolean isInvalidMailboxAuthId(String requestId, String mailBoxAuthId) {
        return !Strings.isNullOrEmpty((String)this.requestToMailboxAuthMap.get(requestId)) && !this.requestToMailboxAuthMap.get(requestId).equals(mailBoxAuthId);
    }

    @Override
    public RevolverCallbackRequest request(String requestId, String mailBoxAuthId) {
        if (this.isInvalidMailboxAuthId(requestId, mailBoxAuthId)) {
            return null;
        }
        return this.callbackRequests.get(requestId);
    }

    @Override
    public RevolverCallbackResponse response(String requestId, String mailBoxAuthId) {
        if (this.isInvalidMailboxAuthId(requestId, mailBoxAuthId)) {
            return null;
        }
        return this.callbackResponse.get(requestId);
    }

    @Override
    public List<RevolverCallbackRequest> requestsByMailbox(String mailboxId) {
        List requestIds = (List)this.mailbox.get((Object)mailboxId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackRequests::containsKey).map(this.callbackRequests::get).collect(Collectors.toList());
    }

    @Override
    public List<RevolverCallbackRequest> requestsByMailboxAuth(String mailboxAuthId) {
        List requestIds = (List)this.mailboxAuth.get((Object)mailboxAuthId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackRequests::containsKey).map(this.callbackRequests::get).collect(Collectors.toList());
    }

    @Override
    public List<RevolverCallbackResponses> responsesByMailbox(String mailboxId) {
        List requestIds = (List)this.mailbox.get((Object)mailboxId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackResponse::containsKey).map(this.callbackResponse::get).map(e -> RevolverCallbackResponses.builder().headers(e.getHeaders()).statusCode(e.getStatusCode()).body(Base64.getEncoder().encodeToString(e.getBody())).build()).collect(Collectors.toList());
    }

    @Override
    public List<RevolverCallbackResponses> responsesByMailboxAuth(String mailboxAuthId) {
        List requestIds = (List)this.mailboxAuth.get((Object)mailboxAuthId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackResponse::containsKey).map(this.callbackResponse::get).map(e -> RevolverCallbackResponses.builder().headers(e.getHeaders()).statusCode(e.getStatusCode()).body(Base64.getEncoder().encodeToString(e.getBody())).build()).collect(Collectors.toList());
    }
}

