/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.dropwizard.Configuration;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.MailBoxConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.config.ServiceDiscoveryConfig;
import io.dropwizard.revolver.core.config.resilience.ResilienceConfig;
import io.dropwizard.revolver.discovery.ServiceResolverConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.riemann.RiemannConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

public class RevolverConfig
extends Configuration {
    @NotNull
    @Valid
    private ClientConfig clientConfig;
    @NotNull
    @Valid
    private RuntimeConfig global;
    @NotNull
    @Valid
    private ServiceResolverConfig serviceResolverConfig;
    @NotNull
    @NotBlank
    private String hystrixStreamPath;
    @NotNull
    @NotEmpty
    @Valid
    private List<RevolverServiceConfig> services;
    @Valid
    private MailBoxConfig mailBox;
    @Max(value=30000L)
    private int callbackTimeout = 3000;
    private boolean dynamicConfig = false;
    @Max(value=30000L)
    private int configPollIntervalSeconds = 600;
    private String dynamicConfigUrl = null;
    @JsonProperty(value="riemann")
    private RiemannConfig riemann;
    private OptimizerConfig optimizerConfig;
    private ServiceDiscoveryConfig serviceDiscoveryConfig;
    private ResilienceConfig resilienceConfig;

    public RevolverConfig(ClientConfig clientConfig, RuntimeConfig global, ServiceResolverConfig serviceResolverConfig, String hystrixStreamPath, List<RevolverServiceConfig> services, MailBoxConfig mailBox, OptimizerConfig optimizerConfig, ServiceDiscoveryConfig serviceDiscoveryConfig, ResilienceConfig resilienceConfig) {
        this.clientConfig = clientConfig;
        this.global = global;
        this.serviceResolverConfig = serviceResolverConfig;
        this.hystrixStreamPath = hystrixStreamPath;
        this.services = services;
        this.mailBox = mailBox;
        this.callbackTimeout = 3000;
        this.dynamicConfig = false;
        this.optimizerConfig = optimizerConfig;
        this.serviceDiscoveryConfig = serviceDiscoveryConfig;
        this.resilienceConfig = resilienceConfig;
    }

    public RevolverConfig() {
        this.global = new RuntimeConfig();
        this.serviceResolverConfig = new ServiceResolverConfig();
        this.hystrixStreamPath = "/hystrix.stream";
        this.services = Lists.newArrayList();
        this.callbackTimeout = 3000;
        this.dynamicConfig = false;
        this.configPollIntervalSeconds = 600;
        this.dynamicConfigUrl = null;
    }

    public static RevolverConfigBuilder builder() {
        return new RevolverConfigBuilder();
    }

    public RevolverConfig(ClientConfig clientConfig, RuntimeConfig global, ServiceResolverConfig serviceResolverConfig, String hystrixStreamPath, List<RevolverServiceConfig> services, MailBoxConfig mailBox, int callbackTimeout, boolean dynamicConfig, int configPollIntervalSeconds, String dynamicConfigUrl, RiemannConfig riemann, OptimizerConfig optimizerConfig, ServiceDiscoveryConfig serviceDiscoveryConfig, ResilienceConfig resilienceConfig) {
        this.clientConfig = clientConfig;
        this.global = global;
        this.serviceResolverConfig = serviceResolverConfig;
        this.hystrixStreamPath = hystrixStreamPath;
        this.services = services;
        this.mailBox = mailBox;
        this.callbackTimeout = callbackTimeout;
        this.dynamicConfig = dynamicConfig;
        this.configPollIntervalSeconds = configPollIntervalSeconds;
        this.dynamicConfigUrl = dynamicConfigUrl;
        this.riemann = riemann;
        this.optimizerConfig = optimizerConfig;
        this.serviceDiscoveryConfig = serviceDiscoveryConfig;
        this.resilienceConfig = resilienceConfig;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public ServiceDiscoveryConfig getServiceDiscoveryConfig() {
        return this.serviceDiscoveryConfig;
    }

    public ResilienceConfig getResilienceConfig() {
        return this.resilienceConfig;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public void setServiceDiscoveryConfig(ServiceDiscoveryConfig serviceDiscoveryConfig) {
        this.serviceDiscoveryConfig = serviceDiscoveryConfig;
    }

    public void setResilienceConfig(ResilienceConfig resilienceConfig) {
        this.resilienceConfig = resilienceConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverConfig)) {
            return false;
        }
        RevolverConfig other = (RevolverConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ClientConfig this$clientConfig = this.getClientConfig();
        ClientConfig other$clientConfig = other.getClientConfig();
        if (this$clientConfig == null ? other$clientConfig != null : !((Object)this$clientConfig).equals(other$clientConfig)) {
            return false;
        }
        RuntimeConfig this$global = this.getGlobal();
        RuntimeConfig other$global = other.getGlobal();
        if (this$global == null ? other$global != null : !((Object)this$global).equals(other$global)) {
            return false;
        }
        ServiceResolverConfig this$serviceResolverConfig = this.getServiceResolverConfig();
        ServiceResolverConfig other$serviceResolverConfig = other.getServiceResolverConfig();
        if (this$serviceResolverConfig == null ? other$serviceResolverConfig != null : !((Object)this$serviceResolverConfig).equals(other$serviceResolverConfig)) {
            return false;
        }
        String this$hystrixStreamPath = this.getHystrixStreamPath();
        String other$hystrixStreamPath = other.getHystrixStreamPath();
        if (this$hystrixStreamPath == null ? other$hystrixStreamPath != null : !this$hystrixStreamPath.equals(other$hystrixStreamPath)) {
            return false;
        }
        List<RevolverServiceConfig> this$services = this.getServices();
        List<RevolverServiceConfig> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        MailBoxConfig this$mailBox = this.getMailBox();
        MailBoxConfig other$mailBox = other.getMailBox();
        if (this$mailBox == null ? other$mailBox != null : !((Object)this$mailBox).equals(other$mailBox)) {
            return false;
        }
        if (this.getCallbackTimeout() != other.getCallbackTimeout()) {
            return false;
        }
        if (this.isDynamicConfig() != other.isDynamicConfig()) {
            return false;
        }
        if (this.getConfigPollIntervalSeconds() != other.getConfigPollIntervalSeconds()) {
            return false;
        }
        String this$dynamicConfigUrl = this.getDynamicConfigUrl();
        String other$dynamicConfigUrl = other.getDynamicConfigUrl();
        if (this$dynamicConfigUrl == null ? other$dynamicConfigUrl != null : !this$dynamicConfigUrl.equals(other$dynamicConfigUrl)) {
            return false;
        }
        RiemannConfig this$riemann = this.getRiemann();
        RiemannConfig other$riemann = other.getRiemann();
        if (this$riemann == null ? other$riemann != null : !this$riemann.equals(other$riemann)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        if (this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig)) {
            return false;
        }
        ServiceDiscoveryConfig this$serviceDiscoveryConfig = this.getServiceDiscoveryConfig();
        ServiceDiscoveryConfig other$serviceDiscoveryConfig = other.getServiceDiscoveryConfig();
        if (this$serviceDiscoveryConfig == null ? other$serviceDiscoveryConfig != null : !((Object)this$serviceDiscoveryConfig).equals(other$serviceDiscoveryConfig)) {
            return false;
        }
        ResilienceConfig this$resilienceConfig = this.getResilienceConfig();
        ResilienceConfig other$resilienceConfig = other.getResilienceConfig();
        return !(this$resilienceConfig == null ? other$resilienceConfig != null : !((Object)this$resilienceConfig).equals(other$resilienceConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientConfig $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : ((Object)$clientConfig).hashCode());
        RuntimeConfig $global = this.getGlobal();
        result = result * 59 + ($global == null ? 43 : ((Object)$global).hashCode());
        ServiceResolverConfig $serviceResolverConfig = this.getServiceResolverConfig();
        result = result * 59 + ($serviceResolverConfig == null ? 43 : ((Object)$serviceResolverConfig).hashCode());
        String $hystrixStreamPath = this.getHystrixStreamPath();
        result = result * 59 + ($hystrixStreamPath == null ? 43 : $hystrixStreamPath.hashCode());
        List<RevolverServiceConfig> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        MailBoxConfig $mailBox = this.getMailBox();
        result = result * 59 + ($mailBox == null ? 43 : ((Object)$mailBox).hashCode());
        result = result * 59 + this.getCallbackTimeout();
        result = result * 59 + (this.isDynamicConfig() ? 79 : 97);
        result = result * 59 + this.getConfigPollIntervalSeconds();
        String $dynamicConfigUrl = this.getDynamicConfigUrl();
        result = result * 59 + ($dynamicConfigUrl == null ? 43 : $dynamicConfigUrl.hashCode());
        RiemannConfig $riemann = this.getRiemann();
        result = result * 59 + ($riemann == null ? 43 : $riemann.hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        ServiceDiscoveryConfig $serviceDiscoveryConfig = this.getServiceDiscoveryConfig();
        result = result * 59 + ($serviceDiscoveryConfig == null ? 43 : ((Object)$serviceDiscoveryConfig).hashCode());
        ResilienceConfig $resilienceConfig = this.getResilienceConfig();
        result = result * 59 + ($resilienceConfig == null ? 43 : ((Object)$resilienceConfig).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverConfig(clientConfig=" + this.getClientConfig() + ", global=" + this.getGlobal() + ", serviceResolverConfig=" + this.getServiceResolverConfig() + ", hystrixStreamPath=" + this.getHystrixStreamPath() + ", services=" + this.getServices() + ", mailBox=" + this.getMailBox() + ", callbackTimeout=" + this.getCallbackTimeout() + ", dynamicConfig=" + this.isDynamicConfig() + ", configPollIntervalSeconds=" + this.getConfigPollIntervalSeconds() + ", dynamicConfigUrl=" + this.getDynamicConfigUrl() + ", riemann=" + this.getRiemann() + ", optimizerConfig=" + this.getOptimizerConfig() + ", serviceDiscoveryConfig=" + this.getServiceDiscoveryConfig() + ", resilienceConfig=" + this.getResilienceConfig() + ")";
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public RuntimeConfig getGlobal() {
        return this.global;
    }

    public void setGlobal(RuntimeConfig global) {
        this.global = global;
    }

    public ServiceResolverConfig getServiceResolverConfig() {
        return this.serviceResolverConfig;
    }

    public void setServiceResolverConfig(ServiceResolverConfig serviceResolverConfig) {
        this.serviceResolverConfig = serviceResolverConfig;
    }

    public String getHystrixStreamPath() {
        return this.hystrixStreamPath;
    }

    public void setHystrixStreamPath(String hystrixStreamPath) {
        this.hystrixStreamPath = hystrixStreamPath;
    }

    public List<RevolverServiceConfig> getServices() {
        return this.services;
    }

    public void setServices(List<RevolverServiceConfig> services) {
        this.services = services;
    }

    public MailBoxConfig getMailBox() {
        return this.mailBox;
    }

    public void setMailBox(MailBoxConfig mailBox) {
        this.mailBox = mailBox;
    }

    public int getCallbackTimeout() {
        return this.callbackTimeout;
    }

    public void setCallbackTimeout(int callbackTimeout) {
        this.callbackTimeout = callbackTimeout;
    }

    public boolean isDynamicConfig() {
        return this.dynamicConfig;
    }

    public void setDynamicConfig(boolean dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public int getConfigPollIntervalSeconds() {
        return this.configPollIntervalSeconds;
    }

    public void setConfigPollIntervalSeconds(int configPollIntervalSeconds) {
        this.configPollIntervalSeconds = configPollIntervalSeconds;
    }

    public String getDynamicConfigUrl() {
        return this.dynamicConfigUrl;
    }

    public void setDynamicConfigUrl(String dynamicConfigUrl) {
        this.dynamicConfigUrl = dynamicConfigUrl;
    }

    public RiemannConfig getRiemann() {
        return this.riemann;
    }

    public void setRiemann(RiemannConfig riemann) {
        this.riemann = riemann;
    }

    public static class RevolverConfigBuilder {
        private ClientConfig clientConfig;
        private RuntimeConfig global;
        private ServiceResolverConfig serviceResolverConfig;
        private String hystrixStreamPath;
        private ArrayList<RevolverServiceConfig> services;
        private MailBoxConfig mailBox;
        private OptimizerConfig optimizerConfig;
        private ServiceDiscoveryConfig serviceDiscoveryConfig;
        private ResilienceConfig resilienceConfig;

        RevolverConfigBuilder() {
        }

        public RevolverConfigBuilder clientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public RevolverConfigBuilder global(RuntimeConfig global) {
            this.global = global;
            return this;
        }

        public RevolverConfigBuilder serviceResolverConfig(ServiceResolverConfig serviceResolverConfig) {
            this.serviceResolverConfig = serviceResolverConfig;
            return this;
        }

        public RevolverConfigBuilder hystrixStreamPath(String hystrixStreamPath) {
            this.hystrixStreamPath = hystrixStreamPath;
            return this;
        }

        public RevolverConfigBuilder service(RevolverServiceConfig service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public RevolverConfigBuilder services(Collection<? extends RevolverServiceConfig> services) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public RevolverConfigBuilder clearServices() {
            if (this.services != null) {
                this.services.clear();
            }
            return this;
        }

        public RevolverConfigBuilder mailBox(MailBoxConfig mailBox) {
            this.mailBox = mailBox;
            return this;
        }

        public RevolverConfigBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public RevolverConfigBuilder serviceDiscoveryConfig(ServiceDiscoveryConfig serviceDiscoveryConfig) {
            this.serviceDiscoveryConfig = serviceDiscoveryConfig;
            return this;
        }

        public RevolverConfigBuilder resilienceConfig(ResilienceConfig resilienceConfig) {
            this.resilienceConfig = resilienceConfig;
            return this;
        }

        public RevolverConfig build() {
            List<RevolverServiceConfig> services;
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<RevolverServiceConfig>(this.services));
                }
            }
            return new RevolverConfig(this.clientConfig, this.global, this.serviceResolverConfig, this.hystrixStreamPath, services, this.mailBox, this.optimizerConfig, this.serviceDiscoveryConfig, this.resilienceConfig);
        }

        public String toString() {
            return "RevolverConfig.RevolverConfigBuilder(clientConfig=" + this.clientConfig + ", global=" + this.global + ", serviceResolverConfig=" + this.serviceResolverConfig + ", hystrixStreamPath=" + this.hystrixStreamPath + ", services=" + this.services + ", mailBox=" + this.mailBox + ", optimizerConfig=" + this.optimizerConfig + ", serviceDiscoveryConfig=" + this.serviceDiscoveryConfig + ", resilienceConfig=" + this.resilienceConfig + ")";
        }
    }
}

