/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import org.slf4j.MDC;

public class RevolverCommandHelper {
    public static String getName(RevolverRequest request) {
        return Joiner.on((String)".").join((Object)request.getService(), (Object)request.getApi(), new Object[0]);
    }

    public static <T extends RevolverRequest> T normalize(T request) {
        if (null == request) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "Request cannot be null");
        }
        TraceInfo traceInfo = request.getTrace();
        if (traceInfo == null) {
            traceInfo = new TraceInfo();
            request.setTrace(traceInfo);
        }
        if (Strings.isNullOrEmpty((String)traceInfo.getRequestId())) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "Request ID must be passed in span");
        }
        if (Strings.isNullOrEmpty((String)traceInfo.getTransactionId())) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "Transaction ID must be passed");
        }
        if (0L == traceInfo.getTimestamp()) {
            traceInfo.setTimestamp(System.currentTimeMillis());
        }
        return request;
    }

    public static void addContextInfo(String command, TraceInfo traceInfo) {
        MDC.put((String)"command", (String)command);
        MDC.put((String)"transactionId", (String)traceInfo.getTransactionId());
        MDC.put((String)"requestId", (String)traceInfo.getRequestId());
        MDC.put((String)"parentRequestId", (String)traceInfo.getParentRequestId());
    }

    public static void removeContextInfo() {
        MDC.remove((String)"command");
        MDC.remove((String)"requestId");
        MDC.remove((String)"transactionId");
        MDC.remove((String)"parentRequestId");
    }
}

