/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.model;

import com.google.common.collect.Maps;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class RevolverHttpRequest
extends RevolverRequest {
    private MultivaluedMap<String, String> headers = new MultivaluedHashMap();
    private MultivaluedMap<String, String> queryParams = new MultivaluedHashMap();
    private Map<String, String> pathParams = Maps.newHashMap();
    private String path;
    private RevolverHttpApiConfig.RequestMethod method;
    private byte[] body;

    public RevolverHttpRequest() {
        this.method = RevolverHttpApiConfig.RequestMethod.GET;
        this.setType("http");
    }

    public RevolverHttpRequest(String service, String api, RevolverHttpApiConfig.RequestMethod method, TraceInfo traceInfo, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> queryParams, Map<String, String> pathParams, String path, byte[] body, RevolverExecutorType revolverExecutorType) {
        super("http", service, api, traceInfo, revolverExecutorType);
        this.headers = headers;
        this.queryParams = queryParams;
        this.pathParams = pathParams;
        this.body = body;
        this.path = path;
        this.method = method;
    }

    public static RevolverHttpRequestBuilder builder() {
        return new RevolverHttpRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpRequest)) {
            return false;
        }
        RevolverHttpRequest other = (RevolverHttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultivaluedMap<String, String> this$headers = this.getHeaders();
        MultivaluedMap<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        MultivaluedMap<String, String> this$queryParams = this.getQueryParams();
        MultivaluedMap<String, String> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !this$queryParams.equals(other$queryParams)) {
            return false;
        }
        Map<String, String> this$pathParams = this.getPathParams();
        Map<String, String> other$pathParams = other.getPathParams();
        if (this$pathParams == null ? other$pathParams != null : !((Object)this$pathParams).equals(other$pathParams)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        RevolverHttpApiConfig.RequestMethod this$method = this.getMethod();
        RevolverHttpApiConfig.RequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MultivaluedMap<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        MultivaluedMap<String, String> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : $queryParams.hashCode());
        Map<String, String> $pathParams = this.getPathParams();
        result = result * 59 + ($pathParams == null ? 43 : ((Object)$pathParams).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        RevolverHttpApiConfig.RequestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public String getPath() {
        return this.path;
    }

    public RevolverHttpApiConfig.RequestMethod getMethod() {
        return this.method;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public void setQueryParams(MultivaluedMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(RevolverHttpApiConfig.RequestMethod method) {
        this.method = method;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    @Override
    public String toString() {
        return "RevolverHttpRequest(headers=" + this.getHeaders() + ", queryParams=" + this.getQueryParams() + ", pathParams=" + this.getPathParams() + ", path=" + this.getPath() + ", method=" + (Object)((Object)this.getMethod()) + ", body=" + Arrays.toString(this.getBody()) + ")";
    }

    public static class RevolverHttpRequestBuilder {
        private String service;
        private String api;
        private RevolverHttpApiConfig.RequestMethod method;
        private TraceInfo traceInfo;
        private MultivaluedMap<String, String> headers;
        private MultivaluedMap<String, String> queryParams;
        private Map<String, String> pathParams;
        private String path;
        private byte[] body;
        private RevolverExecutorType revolverExecutorType;

        RevolverHttpRequestBuilder() {
        }

        public RevolverHttpRequestBuilder service(String service) {
            this.service = service;
            return this;
        }

        public RevolverHttpRequestBuilder api(String api) {
            this.api = api;
            return this;
        }

        public RevolverHttpRequestBuilder method(RevolverHttpApiConfig.RequestMethod method) {
            this.method = method;
            return this;
        }

        public RevolverHttpRequestBuilder traceInfo(TraceInfo traceInfo) {
            this.traceInfo = traceInfo;
            return this;
        }

        public RevolverHttpRequestBuilder headers(MultivaluedMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public RevolverHttpRequestBuilder queryParams(MultivaluedMap<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public RevolverHttpRequestBuilder pathParams(Map<String, String> pathParams) {
            this.pathParams = pathParams;
            return this;
        }

        public RevolverHttpRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RevolverHttpRequestBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public RevolverHttpRequestBuilder revolverExecutorType(RevolverExecutorType revolverExecutorType) {
            this.revolverExecutorType = revolverExecutorType;
            return this;
        }

        public RevolverHttpRequest build() {
            return new RevolverHttpRequest(this.service, this.api, this.method, this.traceInfo, this.headers, this.queryParams, this.pathParams, this.path, this.body, this.revolverExecutorType);
        }

        public String toString() {
            return "RevolverHttpRequest.RevolverHttpRequestBuilder(service=" + this.service + ", api=" + this.api + ", method=" + (Object)((Object)this.method) + ", traceInfo=" + this.traceInfo + ", headers=" + this.headers + ", queryParams=" + this.queryParams + ", pathParams=" + this.pathParams + ", path=" + this.path + ", body=" + Arrays.toString(this.body) + ", revolverExecutorType=" + (Object)((Object)this.revolverExecutorType) + ")";
        }
    }
}

