/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

public class ApiLatencyConfig {
    private boolean downgradeDisable;
    private double latency;

    public static ApiLatencyConfigBuilder builder() {
        return new ApiLatencyConfigBuilder();
    }

    public boolean isDowngradeDisable() {
        return this.downgradeDisable;
    }

    public double getLatency() {
        return this.latency;
    }

    public void setDowngradeDisable(boolean downgradeDisable) {
        this.downgradeDisable = downgradeDisable;
    }

    public void setLatency(double latency) {
        this.latency = latency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiLatencyConfig)) {
            return false;
        }
        ApiLatencyConfig other = (ApiLatencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDowngradeDisable() != other.isDowngradeDisable()) {
            return false;
        }
        return Double.compare(this.getLatency(), other.getLatency()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiLatencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDowngradeDisable() ? 79 : 97);
        long $latency = Double.doubleToLongBits(this.getLatency());
        result = result * 59 + (int)($latency >>> 32 ^ $latency);
        return result;
    }

    public String toString() {
        return "ApiLatencyConfig(downgradeDisable=" + this.isDowngradeDisable() + ", latency=" + this.getLatency() + ")";
    }

    public ApiLatencyConfig() {
    }

    public ApiLatencyConfig(boolean downgradeDisable, double latency) {
        this.downgradeDisable = downgradeDisable;
        this.latency = latency;
    }

    public static class ApiLatencyConfigBuilder {
        private boolean downgradeDisable;
        private double latency;

        ApiLatencyConfigBuilder() {
        }

        public ApiLatencyConfigBuilder downgradeDisable(boolean downgradeDisable) {
            this.downgradeDisable = downgradeDisable;
            return this;
        }

        public ApiLatencyConfigBuilder latency(double latency) {
            this.latency = latency;
            return this;
        }

        public ApiLatencyConfig build() {
            return new ApiLatencyConfig(this.downgradeDisable, this.latency);
        }

        public String toString() {
            return "ApiLatencyConfig.ApiLatencyConfigBuilder(downgradeDisable=" + this.downgradeDisable + ", latency=" + this.latency + ")";
        }
    }
}

