/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.resilience;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.revolver.core.config.resilience.ResilienceConfig;
import io.dropwizard.revolver.core.config.resilience.ThreadPoolConfig;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ResilienceHttpContext
extends RevolverHttpContext {
    private CircuitBreaker defaultCircuitBreaker;
    private Map<String, CircuitBreaker> apiVsCircuitBreaker;
    private Map<String, Bulkhead> poolVsBulkHeadMap;
    private Map<String, Integer> apiVsTimeout;
    private ExecutorService executor;
    private MetricRegistry metrics;
    private ResilienceConfig resilienceConfig;

    public ResilienceHttpContext() {
        this.setupExecutor();
    }

    public ResilienceHttpContext(CircuitBreaker defaultCircuitBreaker, Map<String, CircuitBreaker> apiVsCircuitBreaker, Map<String, Bulkhead> poolVsBulkHeadMap, Map<String, Integer> apiVsTimeout, MetricRegistry metrics, ResilienceConfig resilienceConfig) {
        this.defaultCircuitBreaker = defaultCircuitBreaker;
        this.apiVsCircuitBreaker = apiVsCircuitBreaker;
        this.poolVsBulkHeadMap = poolVsBulkHeadMap;
        this.apiVsTimeout = apiVsTimeout;
        this.metrics = metrics;
        this.resilienceConfig = resilienceConfig;
        this.setupExecutor();
    }

    public ExecutorService getExecutor() {
        if (this.executor == null) {
            this.setupExecutor();
        }
        return this.executor;
    }

    private void setupExecutor() {
        if (this.resilienceConfig == null) {
            this.resilienceConfig = new ResilienceConfig();
        }
        ThreadPoolConfig threadPoolConfig = this.resilienceConfig.getThreadPoolConfig();
        this.executor = new ThreadPoolExecutor(threadPoolConfig.getCorePoolSize(), threadPoolConfig.getMaxPoolSize(), threadPoolConfig.getKeepAliveTimeInSeconds(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadPoolConfig.getQueueSize()));
    }

    public static ResilienceHttpContextBuilder builder() {
        return new ResilienceHttpContextBuilder();
    }

    public CircuitBreaker getDefaultCircuitBreaker() {
        return this.defaultCircuitBreaker;
    }

    public Map<String, CircuitBreaker> getApiVsCircuitBreaker() {
        return this.apiVsCircuitBreaker;
    }

    public Map<String, Bulkhead> getPoolVsBulkHeadMap() {
        return this.poolVsBulkHeadMap;
    }

    public Map<String, Integer> getApiVsTimeout() {
        return this.apiVsTimeout;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public ResilienceConfig getResilienceConfig() {
        return this.resilienceConfig;
    }

    public void setDefaultCircuitBreaker(CircuitBreaker defaultCircuitBreaker) {
        this.defaultCircuitBreaker = defaultCircuitBreaker;
    }

    public void setApiVsCircuitBreaker(Map<String, CircuitBreaker> apiVsCircuitBreaker) {
        this.apiVsCircuitBreaker = apiVsCircuitBreaker;
    }

    public void setPoolVsBulkHeadMap(Map<String, Bulkhead> poolVsBulkHeadMap) {
        this.poolVsBulkHeadMap = poolVsBulkHeadMap;
    }

    public void setApiVsTimeout(Map<String, Integer> apiVsTimeout) {
        this.apiVsTimeout = apiVsTimeout;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setResilienceConfig(ResilienceConfig resilienceConfig) {
        this.resilienceConfig = resilienceConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResilienceHttpContext)) {
            return false;
        }
        ResilienceHttpContext other = (ResilienceHttpContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CircuitBreaker this$defaultCircuitBreaker = this.getDefaultCircuitBreaker();
        CircuitBreaker other$defaultCircuitBreaker = other.getDefaultCircuitBreaker();
        if (this$defaultCircuitBreaker == null ? other$defaultCircuitBreaker != null : !this$defaultCircuitBreaker.equals(other$defaultCircuitBreaker)) {
            return false;
        }
        Map<String, CircuitBreaker> this$apiVsCircuitBreaker = this.getApiVsCircuitBreaker();
        Map<String, CircuitBreaker> other$apiVsCircuitBreaker = other.getApiVsCircuitBreaker();
        if (this$apiVsCircuitBreaker == null ? other$apiVsCircuitBreaker != null : !((Object)this$apiVsCircuitBreaker).equals(other$apiVsCircuitBreaker)) {
            return false;
        }
        Map<String, Bulkhead> this$poolVsBulkHeadMap = this.getPoolVsBulkHeadMap();
        Map<String, Bulkhead> other$poolVsBulkHeadMap = other.getPoolVsBulkHeadMap();
        if (this$poolVsBulkHeadMap == null ? other$poolVsBulkHeadMap != null : !((Object)this$poolVsBulkHeadMap).equals(other$poolVsBulkHeadMap)) {
            return false;
        }
        Map<String, Integer> this$apiVsTimeout = this.getApiVsTimeout();
        Map<String, Integer> other$apiVsTimeout = other.getApiVsTimeout();
        if (this$apiVsTimeout == null ? other$apiVsTimeout != null : !((Object)this$apiVsTimeout).equals(other$apiVsTimeout)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        ResilienceConfig this$resilienceConfig = this.getResilienceConfig();
        ResilienceConfig other$resilienceConfig = other.getResilienceConfig();
        return !(this$resilienceConfig == null ? other$resilienceConfig != null : !((Object)this$resilienceConfig).equals(other$resilienceConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResilienceHttpContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CircuitBreaker $defaultCircuitBreaker = this.getDefaultCircuitBreaker();
        result = result * 59 + ($defaultCircuitBreaker == null ? 43 : $defaultCircuitBreaker.hashCode());
        Map<String, CircuitBreaker> $apiVsCircuitBreaker = this.getApiVsCircuitBreaker();
        result = result * 59 + ($apiVsCircuitBreaker == null ? 43 : ((Object)$apiVsCircuitBreaker).hashCode());
        Map<String, Bulkhead> $poolVsBulkHeadMap = this.getPoolVsBulkHeadMap();
        result = result * 59 + ($poolVsBulkHeadMap == null ? 43 : ((Object)$poolVsBulkHeadMap).hashCode());
        Map<String, Integer> $apiVsTimeout = this.getApiVsTimeout();
        result = result * 59 + ($apiVsTimeout == null ? 43 : ((Object)$apiVsTimeout).hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        ResilienceConfig $resilienceConfig = this.getResilienceConfig();
        result = result * 59 + ($resilienceConfig == null ? 43 : ((Object)$resilienceConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ResilienceHttpContext(defaultCircuitBreaker=" + this.getDefaultCircuitBreaker() + ", apiVsCircuitBreaker=" + this.getApiVsCircuitBreaker() + ", poolVsBulkHeadMap=" + this.getPoolVsBulkHeadMap() + ", apiVsTimeout=" + this.getApiVsTimeout() + ", executor=" + this.getExecutor() + ", metrics=" + this.getMetrics() + ", resilienceConfig=" + this.getResilienceConfig() + ")";
    }

    public ResilienceHttpContext(CircuitBreaker defaultCircuitBreaker, Map<String, CircuitBreaker> apiVsCircuitBreaker, Map<String, Bulkhead> poolVsBulkHeadMap, Map<String, Integer> apiVsTimeout, ExecutorService executor, MetricRegistry metrics, ResilienceConfig resilienceConfig) {
        this.defaultCircuitBreaker = defaultCircuitBreaker;
        this.apiVsCircuitBreaker = apiVsCircuitBreaker;
        this.poolVsBulkHeadMap = poolVsBulkHeadMap;
        this.apiVsTimeout = apiVsTimeout;
        this.executor = executor;
        this.metrics = metrics;
        this.resilienceConfig = resilienceConfig;
    }

    public static class ResilienceHttpContextBuilder {
        private CircuitBreaker defaultCircuitBreaker;
        private Map<String, CircuitBreaker> apiVsCircuitBreaker;
        private Map<String, Bulkhead> poolVsBulkHeadMap;
        private Map<String, Integer> apiVsTimeout;
        private ExecutorService executor;
        private MetricRegistry metrics;
        private ResilienceConfig resilienceConfig;

        ResilienceHttpContextBuilder() {
        }

        public ResilienceHttpContextBuilder defaultCircuitBreaker(CircuitBreaker defaultCircuitBreaker) {
            this.defaultCircuitBreaker = defaultCircuitBreaker;
            return this;
        }

        public ResilienceHttpContextBuilder apiVsCircuitBreaker(Map<String, CircuitBreaker> apiVsCircuitBreaker) {
            this.apiVsCircuitBreaker = apiVsCircuitBreaker;
            return this;
        }

        public ResilienceHttpContextBuilder poolVsBulkHeadMap(Map<String, Bulkhead> poolVsBulkHeadMap) {
            this.poolVsBulkHeadMap = poolVsBulkHeadMap;
            return this;
        }

        public ResilienceHttpContextBuilder apiVsTimeout(Map<String, Integer> apiVsTimeout) {
            this.apiVsTimeout = apiVsTimeout;
            return this;
        }

        public ResilienceHttpContextBuilder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public ResilienceHttpContextBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public ResilienceHttpContextBuilder resilienceConfig(ResilienceConfig resilienceConfig) {
            this.resilienceConfig = resilienceConfig;
            return this;
        }

        public ResilienceHttpContext build() {
            return new ResilienceHttpContext(this.defaultCircuitBreaker, this.apiVsCircuitBreaker, this.poolVsBulkHeadMap, this.apiVsTimeout, this.executor, this.metrics, this.resilienceConfig);
        }

        public String toString() {
            return "ResilienceHttpContext.ResilienceHttpContextBuilder(defaultCircuitBreaker=" + this.defaultCircuitBreaker + ", apiVsCircuitBreaker=" + this.apiVsCircuitBreaker + ", poolVsBulkHeadMap=" + this.poolVsBulkHeadMap + ", apiVsTimeout=" + this.apiVsTimeout + ", executor=" + this.executor + ", metrics=" + this.metrics + ", resilienceConfig=" + this.resilienceConfig + ")";
        }
    }
}

