/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.persistence;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.dropwizard.revolver.aeroapike.AerospikeConnectionManager;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverCallbackResponses;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.core.config.AerospikeMailBoxConfig;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeroSpikePersistenceProvider
implements PersistenceProvider {
    private static final Logger log = LoggerFactory.getLogger(AeroSpikePersistenceProvider.class);
    private static final String IDX_MAILBOX_ID = "idx_mailbox_id";
    private static final String MAILBOX_SET_NAME = "mailbox_messages";
    private static final String DEFAULT_MAILBOX_ID = "NONE";
    private static final TypeReference<Map<String, List<String>>> headerAndQueryParamTypeReference = new TypeReference<Map<String, List<String>>>(){};
    private final AerospikeMailBoxConfig mailBoxConfig;
    private final ObjectMapper objectMapper;

    public AeroSpikePersistenceProvider(AerospikeMailBoxConfig mailBoxConfig, ObjectMapper objectMapper) {
        this.mailBoxConfig = mailBoxConfig;
        this.objectMapper = objectMapper;
        try {
            IndexTask idxMailboxId = AerospikeConnectionManager.getClient().createIndex(null, mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, IDX_MAILBOX_ID, "mailbox_id", IndexType.STRING);
            idxMailboxId.waitTillComplete();
            IndexTask idxMessageState = AerospikeConnectionManager.getClient().createIndex(null, mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, "idx_message_state", "state", IndexType.STRING);
            idxMailboxId.waitTillComplete();
            idxMessageState.waitTillComplete();
        }
        catch (AerospikeException e) {
            log.warn("Failed to create indexes: Error Code - {} | Message: {}", (Object)e.getResultCode(), (Object)e.getMessage());
        }
    }

    @Override
    public boolean exists(String requestId) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        return AerospikeConnectionManager.getClient().exists(AerospikeConnectionManager.readPolicy, key);
    }

    @Override
    public void saveRequest(String requestId, String mailboxId, RevolverCallbackRequest request, int ttl) throws Exception {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        try {
            Bin service = new Bin("service", request.getService());
            Bin api = new Bin("api", request.getApi());
            Bin mode = new Bin("mode", request.getMode().toUpperCase());
            Bin method = new Bin("method", Strings.isNullOrEmpty((String)request.getMethod()) ? null : request.getMethod().toUpperCase());
            Bin path = new Bin("path", request.getPath());
            Bin mailBoxId = new Bin("mailbox_id", mailboxId == null ? this.mailBoxConfig.getDefaultMailboxId() : mailboxId);
            Bin queryParams = new Bin("query_params", this.objectMapper.writeValueAsString(request.getQueryParams()));
            Bin callbackUri = new Bin("callback_uri", request.getCallbackUri());
            Bin requestHeaders = new Bin("req_headers", this.objectMapper.writeValueAsString(request.getHeaders()));
            Bin requestBody = new Bin("req_body", request.getBody());
            Bin requestTime = new Bin("req_time", Instant.now().toEpochMilli());
            Bin created = new Bin("created", Instant.now().toEpochMilli());
            Bin updated = new Bin("updated", Instant.now().toEpochMilli());
            Bin state = new Bin("state", RevolverRequestState.RECEIVED.name());
            WritePolicy wp = ttl <= 0 ? AerospikeConnectionManager.writePolicy : AerospikeConnectionManager.getWritePolicy(ttl);
            AerospikeConnectionManager.getClient().put(wp, key, new Bin[]{service, api, mode, method, path, mailBoxId, queryParams, callbackUri, requestHeaders, requestBody, requestTime, created, updated, state});
            log.info("Mailbox Message saved. Key: {} | TTL: {}", (Object)requestId, (Object)ttl);
        }
        catch (JsonProcessingException e) {
            log.warn("Error encoding request", (Throwable)e);
        }
    }

    @Override
    public void saveRequest(String requestId, String mailboxId, RevolverCallbackRequest request) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        try {
            Bin service = new Bin("service", request.getService());
            Bin api = new Bin("api", request.getApi());
            Bin mode = new Bin("mode", request.getMode().toUpperCase());
            Bin method = new Bin("method", Strings.isNullOrEmpty((String)request.getMethod()) ? null : request.getMethod().toUpperCase());
            Bin path = new Bin("path", request.getPath());
            Bin mailBoxId = new Bin("mailbox_id", mailboxId == null ? this.mailBoxConfig.getDefaultMailboxId() : mailboxId);
            Bin queryParams = new Bin("query_params", this.objectMapper.writeValueAsString(request.getQueryParams()));
            Bin callbackUri = new Bin("callback_uri", request.getCallbackUri());
            Bin requestHeaders = new Bin("req_headers", this.objectMapper.writeValueAsString(request.getHeaders()));
            Bin requestBody = new Bin("req_body", request.getBody());
            Bin requestTime = new Bin("req_time", Instant.now().toEpochMilli());
            Bin created = new Bin("created", Instant.now().toEpochMilli());
            Bin updated = new Bin("updated", Instant.now().toEpochMilli());
            Bin state = new Bin("state", RevolverRequestState.RECEIVED.name());
            AerospikeConnectionManager.getClient().put(AerospikeConnectionManager.writePolicy, key, new Bin[]{service, api, mode, method, path, mailBoxId, queryParams, callbackUri, requestHeaders, requestBody, requestTime, created, updated, state});
        }
        catch (JsonProcessingException e) {
            log.warn("Error encoding request", (Throwable)e);
        }
    }

    @Override
    public void setRequestState(String requestId, RevolverRequestState state, int ttl) throws Exception {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Record record = AerospikeConnectionManager.getClient().get(AerospikeConnectionManager.readPolicy, key, new String[]{"state"});
        RevolverRequestState requestState = RevolverRequestState.valueOf(record.getString("state"));
        if (requestState != RevolverRequestState.RESPONDED) {
            WritePolicy wp = ttl <= 0 ? AerospikeConnectionManager.writePolicy : AerospikeConnectionManager.getWritePolicy(ttl);
            Bin binState = new Bin("state", state.name());
            Bin updated = new Bin("updated", Instant.now().toEpochMilli());
            AerospikeConnectionManager.getClient().operate(wp, key, new Operation[]{Operation.put((Bin)binState), Operation.put((Bin)updated)});
        }
    }

    @Override
    public void saveResponse(String requestId, RevolverCallbackResponse response, int ttl) throws Exception {
        long start = System.currentTimeMillis();
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Bin state = new Bin("state", RevolverRequestState.RESPONDED.name());
        try {
            Bin responseHeaders = new Bin("resp_headers", this.objectMapper.writeValueAsString(response.getHeaders()));
            Bin responseBody = new Bin("resp_body", response.getBody());
            Bin responseStatusCode = new Bin("resp_code", response.getStatusCode());
            Bin responseTime = new Bin("resp_time", Instant.now().toEpochMilli());
            Bin updated = new Bin("updated", Instant.now().toEpochMilli());
            WritePolicy wp = ttl <= 0 ? AerospikeConnectionManager.writePolicy : AerospikeConnectionManager.getWritePolicy(ttl);
            AerospikeConnectionManager.getClient().operate(wp, key, new Operation[]{Operation.put((Bin)state), Operation.put((Bin)responseHeaders), Operation.put((Bin)responseBody), Operation.put((Bin)responseStatusCode), Operation.put((Bin)responseTime), Operation.put((Bin)updated)});
            log.info("Response save complete for request id: {} in {} ms", (Object)requestId, (Object)(System.currentTimeMillis() - start));
        }
        catch (JsonProcessingException e) {
            log.warn("Error encoding response headers", (Throwable)e);
        }
    }

    @Override
    public RevolverRequestState requestState(String requestId) {
        return this.requestState(requestId, null, false);
    }

    @Override
    public RevolverRequestState requestState(String requestId, String mailBoxId) {
        return this.requestState(requestId, mailBoxId, true);
    }

    @Override
    public RevolverCallbackResponse response(String requestId, String mailBoxId) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Record record = AerospikeConnectionManager.getClient().get(AerospikeConnectionManager.readPolicy, key);
        if (record == null || this.isInvalidMailboxId(true, mailBoxId, record)) {
            return null;
        }
        return this.recordToResponse(record);
    }

    @Override
    public List<RevolverCallbackResponses> responses(String mailboxId) {
        Statement statement = new Statement();
        statement.setNamespace(this.mailBoxConfig.getNamespace());
        statement.setSetName(MAILBOX_SET_NAME);
        statement.setIndexName(IDX_MAILBOX_ID);
        statement.setFilter(Filter.equal((String)"mailbox_id", (String)mailboxId));
        ArrayList<RevolverCallbackResponses> responses = new ArrayList<RevolverCallbackResponses>();
        try (RecordSet records = AerospikeConnectionManager.getClient().query(null, statement);){
            while (records.next()) {
                Record record = records.getRecord();
                RevolverRequestState state = RevolverRequestState.valueOf(record.getString("state"));
                if (state != RevolverRequestState.ERROR && state != RevolverRequestState.RESPONDED) continue;
                responses.add(this.recordToResponses(record, records.getKey()));
            }
        }
        return responses;
    }

    @Override
    public RevolverCallbackRequest request(String requestId) {
        return this.request(requestId, null, false);
    }

    @Override
    public RevolverCallbackRequest request(String requestId, String mailBoxId) {
        return this.request(requestId, mailBoxId, true);
    }

    @Override
    public List<RevolverCallbackRequest> requests(String mailboxId) {
        Statement statement = new Statement();
        statement.setNamespace(this.mailBoxConfig.getNamespace());
        statement.setSetName(MAILBOX_SET_NAME);
        statement.setIndexName(IDX_MAILBOX_ID);
        statement.setFilter(Filter.equal((String)"mailbox_id", (String)mailboxId));
        ArrayList<RevolverCallbackRequest> requests = new ArrayList<RevolverCallbackRequest>();
        try (RecordSet records = AerospikeConnectionManager.getClient().query(null, statement);){
            while (records.next()) {
                requests.add(this.recordToRequest(records.getRecord()));
            }
        }
        return requests;
    }

    private RevolverRequestState requestState(String requestId, String mailBoxId, boolean enforceMailboxIdCheck) {
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Record record = AerospikeConnectionManager.getClient().get(AerospikeConnectionManager.readPolicy, key);
        if (record == null || this.isInvalidMailboxId(enforceMailboxIdCheck, mailBoxId, record)) {
            return RevolverRequestState.UNKNOWN;
        }
        return RevolverRequestState.valueOf(record.getString("state"));
    }

    private RevolverCallbackRequest request(String requestId, String mailBoxId, boolean enforceMailboxIdCheck) {
        long start = System.currentTimeMillis();
        Key key = new Key(this.mailBoxConfig.getNamespace(), MAILBOX_SET_NAME, requestId);
        Record record = AerospikeConnectionManager.getClient().get(AerospikeConnectionManager.readPolicy, key);
        if (record == null || this.isInvalidMailboxId(enforceMailboxIdCheck, mailBoxId, record)) {
            return null;
        }
        RevolverCallbackRequest request = this.recordToRequest(record);
        log.info("Callback request fetch for request id: {} complete in {} ms", (Object)requestId, (Object)(System.currentTimeMillis() - start));
        return request;
    }

    private boolean isInvalidMailboxId(boolean enforceMailboxIdCheck, String mailBoxId, Record record) {
        return enforceMailboxIdCheck && !Arrays.asList(DEFAULT_MAILBOX_ID, this.mailBoxConfig.getDefaultMailboxId()).contains(record.getString("mailbox_id")) && !record.getString("mailbox_id").equals(mailBoxId);
    }

    private RevolverCallbackRequest recordToRequest(Record record) {
        Map<String, List> headers = new HashMap();
        Map<String, List> queryParams = new HashMap();
        try {
            headers = (Map)this.objectMapper.readValue(record.getString("req_headers"), headerAndQueryParamTypeReference);
            queryParams = (Map)this.objectMapper.readValue(record.getString("query_params"), headerAndQueryParamTypeReference);
        }
        catch (IOException e) {
            log.warn("Error decoding response", (Throwable)e);
        }
        StringKeyIgnoreCaseMultivaluedMap headersKeyIgnoreCaseMap = new StringKeyIgnoreCaseMultivaluedMap();
        StringKeyIgnoreCaseMultivaluedMap queryParamsKeyIgnoreCaseMap = new StringKeyIgnoreCaseMultivaluedMap();
        headers.forEach(((Map)headersKeyIgnoreCaseMap)::put);
        queryParams.forEach(((Map)queryParamsKeyIgnoreCaseMap)::put);
        return RevolverCallbackRequest.builder().headers((Map<String, List<String>>)headersKeyIgnoreCaseMap).api(record.getString("api")).callbackUri(record.getString("callback_uri")).body(record.getValue("req_body") == null ? null : (byte[])record.getValue("req_body")).method(record.getString("method")).mode(record.getString("mode")).path(record.getString("path")).queryParams((Map<String, List<String>>)queryParamsKeyIgnoreCaseMap).service(record.getString("service")).build();
    }

    private RevolverCallbackResponse recordToResponse(Record record) {
        HashMap<String, List<String>> headers = new HashMap();
        try {
            headers = (Map)this.objectMapper.readValue(record.getString("resp_headers"), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        }
        catch (IOException e) {
            log.warn("Error decoding response headers", (Throwable)e);
        }
        return RevolverCallbackResponse.builder().body((byte[])record.getValue("resp_body")).statusCode(record.getInt("resp_code")).headers(headers).build();
    }

    private RevolverCallbackResponses recordToResponses(Record record, Key key) {
        HashMap<String, List<String>> headers = new HashMap();
        try {
            headers = (Map)this.objectMapper.readValue(record.getString("resp_headers"), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        }
        catch (IOException e) {
            log.warn("Error decoding response headers", (Throwable)e);
        }
        return RevolverCallbackResponses.builder().body(Base64.getEncoder().encodeToString((byte[])record.getValue("resp_body"))).statusCode(record.getInt("resp_code")).headers(headers).requestId((String)key.userKey.getObject()).build();
    }

    private static abstract class BinNames {
        static final String MAILBOX_ID = "mailbox_id";
        static final String SERVICE = "service";
        static final String API = "api";
        static final String MODE = "mode";
        static final String METHOD = "method";
        static final String PATH = "path";
        static final String QUERY_PARAMS = "query_params";
        static final String CALLBACK_URI = "callback_uri";
        static final String REQUEST_HEADERS = "req_headers";
        static final String REQUEST_BODY = "req_body";
        static final String REQUEST_TIME = "req_time";
        static final String RESPONSE_HEADERS = "resp_headers";
        static final String RESPONSE_BODY = "resp_body";
        static final String RESPONSE_TIME = "resp_time";
        static final String RESPONSE_STATUS_CODE = "resp_code";
        static final String CREATED = "created";
        static final String UPDATED = "updated";
        static final String STATE = "state";

        private BinNames() {
        }
    }
}

